/*
 * Decompiled with CFR 0.152.
 */
package com.isti.dhi;

import com.isti.dhi.IChannelInfo;
import com.isti.dhi2mseed.Utils;
import edu.iris.Fissures.IfEvent.EventDC;
import edu.iris.Fissures.IfEvent.EventDCHelper;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkDC;
import edu.iris.Fissures.IfNetwork.NetworkDCHelper;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfSeismogramDC.DataCenter;
import edu.iris.Fissures.IfSeismogramDC.DataCenterHelper;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.mseed.FissuresConvert;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.StringTokenizer;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class FissuresUtils {
    public static final String EMPTY_STRING = "";
    public static final DateFormat fissDateFormatter = Utils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");

    public static boolean datesInTimeRange(Date beginDateObj, Date endDateObj, TimeRange timeRangeObj) {
        MicroSecondDate rEndDateObj;
        MicroSecondDate rStartDateObj;
        try {
            rStartDateObj = new ISOTime(timeRangeObj.start_time.date_time).getDate();
            rEndDateObj = new ISOTime(timeRangeObj.end_time.date_time).getDate();
        }
        catch (Exception ex) {
            return false;
        }
        if (endDateObj == null) {
            if (beginDateObj == null) {
                return true;
            }
            return !beginDateObj.before(rStartDateObj) && !beginDateObj.after(rEndDateObj);
        }
        return !beginDateObj.after(rEndDateObj) && !endDateObj.before(rStartDateObj);
    }

    public static boolean enterDefaultPropValue(Properties propObj, String nameStr, String defaultStr) {
        if (propObj != null && propObj.getProperty(nameStr) == null) {
            propObj.setProperty(nameStr, defaultStr);
            return true;
        }
        return false;
    }

    public static Calendar getCalendar(Time timeObj) {
        Date dateObj = FissuresUtils.getDate(timeObj);
        GregorianCalendar calObj = new GregorianCalendar();
        calObj.setTime(dateObj);
        return calObj;
    }

    public static int getCalendarField(String value) {
        if ((value = value.toLowerCase()).indexOf("milli") >= 0 || value.indexOf("ms") >= 0) {
            return 14;
        }
        if (value.indexOf("min") >= 0) {
            return 12;
        }
        if (value.indexOf("sec") >= 0) {
            return 13;
        }
        if (value.indexOf("hour") >= 0) {
            return 10;
        }
        if (value.indexOf("day") >= 0) {
            return 5;
        }
        if (value.indexOf("week") >= 0) {
            return 3;
        }
        if (value.indexOf("month") >= 0) {
            return 2;
        }
        return 14;
    }

    public static int getCalendarValue(String value) {
        try {
            char c;
            int valueIndex;
            int valueLength = value.length();
            for (valueIndex = 0; valueIndex < valueLength && Character.isDigit(c = value.charAt(valueIndex)); ++valueIndex) {
            }
            if (valueIndex < valueLength) {
                value = value.substring(valueIndex);
            }
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static ChannelId getChannelId(NetworkId networkId, String stationCode, String siteCode, String channelCode, Time channelBeginTime) {
        return new ChannelId(networkId, stationCode, siteCode, channelCode, channelBeginTime);
    }

    public static Date getDate(Time timeObj) {
        try {
            return new ISOTime(timeObj.date_time).getDate();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Time getTime(Calendar calObj) {
        return new Time(fissDateFormatter.format(calObj.getTime()), -1);
    }

    public static Time getTime(Date dateObj) {
        return new Time(fissDateFormatter.format(dateObj), -1);
    }

    public static Time getTime(long date) {
        return new Time(fissDateFormatter.format(new Date(date)), -1);
    }

    public static String getUnitsName(Unit the_units) {
        return FissuresUtils.getUnitsName(the_units, false);
    }

    public static String getUnitsName(Unit the_units, boolean shortFlag) {
        String prefixText = EMPTY_STRING;
        String unitsName = the_units.name;
        if (unitsName == null || unitsName.length() <= 0) {
            block0 : switch (the_units.the_unit_base.value()) {
                case 0: {
                    unitsName = "meters";
                    break;
                }
                case 1: {
                    unitsName = "grams";
                    break;
                }
                case 2: {
                    switch (the_units.exponent) {
                        case -1: {
                            unitsName = "hertz";
                            break block0;
                        }
                    }
                    unitsName = "seconds";
                    break;
                }
                case 3: {
                    unitsName = "amperes";
                    break;
                }
                case 4: {
                    unitsName = "kelvin";
                    break;
                }
                case 5: {
                    unitsName = "moles";
                    break;
                }
                case 6: {
                    unitsName = "candela";
                    break;
                }
                case 7: {
                    unitsName = "count";
                    break;
                }
                case 8: {
                    unitsName = "composite";
                }
            }
            if (prefixText.length() <= 0) {
                switch (the_units.power) {
                    case 24: {
                        prefixText = "yotta";
                        break;
                    }
                    case 21: {
                        prefixText = "zetta";
                        break;
                    }
                    case 18: {
                        prefixText = "exa";
                        break;
                    }
                    case 15: {
                        prefixText = "peta";
                        break;
                    }
                    case 12: {
                        prefixText = "tera";
                        break;
                    }
                    case 9: {
                        prefixText = "giga";
                        break;
                    }
                    case 6: {
                        prefixText = "mega";
                        break;
                    }
                    case 3: {
                        prefixText = "kilo";
                        break;
                    }
                    case 2: {
                        prefixText = "hecto";
                        break;
                    }
                    case 1: {
                        prefixText = "deka";
                        break;
                    }
                    case -1: {
                        prefixText = "deci";
                        break;
                    }
                    case -2: {
                        prefixText = "centi";
                        break;
                    }
                    case -3: {
                        prefixText = "milli";
                        break;
                    }
                    case -6: {
                        prefixText = "micro";
                        break;
                    }
                    case -9: {
                        prefixText = "nano";
                        break;
                    }
                    case -12: {
                        prefixText = "pico";
                        break;
                    }
                    case -15: {
                        prefixText = "femto";
                        break;
                    }
                    case -18: {
                        prefixText = "atto";
                        break;
                    }
                    case -21: {
                        prefixText = "zepto";
                        break;
                    }
                    case -24: {
                        prefixText = "yocto";
                    }
                }
            }
        }
        if (shortFlag) {
            if (prefixText.length() > 1) {
                prefixText = prefixText.substring(0, 1);
            }
            if (unitsName.length() > 1) {
                unitsName = unitsName.substring(0, 1);
            }
        }
        return prefixText + unitsName;
    }

    public static String makeNetAttrString(NetworkAttr netAttrObj) {
        if (netAttrObj == null) {
            return "(null)";
        }
        NetworkId netIdObj = netAttrObj.get_id();
        String retStr = netIdObj != null ? netIdObj.network_code + " " + FissuresUtils.timeToStr(netIdObj.begin_time) : "(null) (null)";
        TimeRange timeRangeObj = netAttrObj.effective_time;
        retStr = timeRangeObj != null ? retStr + " " + FissuresUtils.timeToStr(timeRangeObj.start_time) + FissuresUtils.timeToStr(timeRangeObj.end_time) : retStr + " (null) (null)";
        return retStr;
    }

    public static String timeToStr(Time timeObj) {
        return timeObj != null ? timeObj.date_time : "(null)";
    }

    public static EventDC getEventDC(NamingContextExt namingContextObj, String dns, String objectname) throws NotFound, CannotProceed, InvalidName, org.omg.CORBA.ORBPackage.InvalidName {
        return EventDCHelper.narrow(FissuresUtils.resolve(namingContextObj, dns, "EventDC", objectname));
    }

    public static NetworkDC getNetworkDC(NamingContextExt namingContextObj, String dns, String objectname) throws NotFound, CannotProceed, InvalidName, org.omg.CORBA.ORBPackage.InvalidName {
        return NetworkDCHelper.narrow(FissuresUtils.resolve(namingContextObj, dns, "NetworkDC", objectname));
    }

    public static DataCenter getSeismogramDC(NamingContextExt namingContextObj, String dns, String objectname) throws NotFound, CannotProceed, InvalidName, org.omg.CORBA.ORBPackage.InvalidName {
        return DataCenterHelper.narrow(FissuresUtils.resolve(namingContextObj, dns, "DataCenter", objectname));
    }

    public static Object resolve(NamingContextExt namingContextObj, String dns, String interfacename, String objectname) throws NotFound, CannotProceed, InvalidName, org.omg.CORBA.ORBPackage.InvalidName {
        dns = FissuresUtils.appendKindNames(dns);
        if (interfacename != null && interfacename.length() != 0) {
            dns = dns + "/" + interfacename + ".interface";
        }
        if (objectname != null && objectname.length() != 0) {
            dns = dns + "/" + objectname + ".object" + FissuresUtils.getVersion();
        }
        return namingContextObj.resolve(namingContextObj.to_name(dns));
    }

    public static String appendKindNames(String dns) {
        dns = "Fissures/" + dns + "/";
        StringTokenizer tokenizer = new StringTokenizer(dns, "/");
        String rtnValue = new String();
        while (tokenizer.hasMoreElements()) {
            String temp = (String)tokenizer.nextElement();
            temp = temp + ".dns/";
            rtnValue = rtnValue + temp;
        }
        return rtnValue.substring(0, rtnValue.length() - 1);
    }

    public static String getVersion() {
        String version = "1.0";
        String rtnValue = new String();
        String prefix = new String("_FVer");
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        while (tokenizer.hasMoreElements()) {
            String temp = (String)tokenizer.nextElement();
            temp = temp + "\\.";
            rtnValue = rtnValue + temp;
        }
        return prefix + rtnValue.substring(0, rtnValue.length() - 2);
    }

    public static String getMseedFilename(IChannelInfo channelInfo, Date dateObj) {
        String dateFormatText = "yyyyMMdd.HHmmss";
        DateFormat dateFormat = Utils.createDateFormat("yyyyMMdd.HHmmss");
        String outputFilename = channelInfo.getStationName() + "." + channelInfo.getChannelName() + "." + channelInfo.getNetworkName() + "." + channelInfo.getLocationName() + "." + dateFormat.format(dateObj) + ".mseed";
        return outputFilename;
    }

    public static File getMSeedFile(IChannelInfo channelInfo, Date dateObj, File outputFile, boolean fileExistErrorFlag) throws IllegalArgumentException {
        String outputFilename;
        File outputDir;
        if (!outputFile.exists()) {
            File outputDir2 = outputFile.getParentFile();
            if (outputDir2 == null || !outputDir2.isDirectory()) {
                throw new IllegalArgumentException("output directory does not exist");
            }
        } else if (outputFile.isDirectory() ? (outputFile = new File(outputDir = outputFile, outputFilename = FissuresUtils.getMseedFilename(channelInfo, dateObj))).exists() && fileExistErrorFlag : fileExistErrorFlag) {
            throw new IllegalArgumentException("output file already exists");
        }
        return outputFile;
    }

    public static File writeMSeed(LocalSeismogram localSeismogram, File outputFile) throws SeedFormatException, IOException {
        DataRecord[] dr = FissuresConvert.toMSeed(localSeismogram);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        for (int i = 0; i < dr.length; ++i) {
            dr[i].write(dos);
        }
        dos.close();
        return outputFile;
    }
}

