/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.ConnectTimeoutPolicy;
import com.ooc.OB.ConnectTimeoutPolicyHelper;
import com.ooc.OB.InterceptorPolicy;
import com.ooc.OB.InterceptorPolicyHelper;
import com.ooc.OB.LocationTransparencyPolicy;
import com.ooc.OB.LocationTransparencyPolicyHelper;
import com.ooc.OB.RequestTimeoutPolicy;
import com.ooc.OB.RequestTimeoutPolicyHelper;
import com.ooc.OB.RetryPolicy;
import com.ooc.OB.RetryPolicyHelper;
import com.ooc.OB.TimeoutPolicy;
import com.ooc.OB.TimeoutPolicyHelper;
import org.omg.CORBA.Policy;
import org.omg.Messaging.SyncScopePolicy;
import org.omg.Messaging.SyncScopePolicyHelper;

public final class RefCountPolicyList {
    public Policy[] value;
    public short retry;
    public int connectTimeout;
    public int requestTimeout;
    public short syncScope;
    public short locationTransparency;
    public boolean interceptor;

    private static short getRetry(Policy[] policyArray) {
        int n = 0;
        while (n < policyArray.length) {
            if (policyArray[n].policy_type() == 0x4F4F0004) {
                RetryPolicy retryPolicy = RetryPolicyHelper.narrow(policyArray[n]);
                return retryPolicy.value();
            }
            ++n;
        }
        return 1;
    }

    private static int getConnectTimeout(Policy[] policyArray) {
        int n = 0;
        while (n < policyArray.length) {
            if (policyArray[n].policy_type() == 1330577416) {
                ConnectTimeoutPolicy connectTimeoutPolicy = ConnectTimeoutPolicyHelper.narrow(policyArray[n]);
                return connectTimeoutPolicy.value();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < policyArray.length) {
            if (policyArray[n2].policy_type() == 1330577413) {
                TimeoutPolicy timeoutPolicy = TimeoutPolicyHelper.narrow(policyArray[n2]);
                return timeoutPolicy.value();
            }
            ++n2;
        }
        return -1;
    }

    private static int getRequestTimeout(Policy[] policyArray) {
        int n = 0;
        while (n < policyArray.length) {
            if (policyArray[n].policy_type() == 1330577417) {
                RequestTimeoutPolicy requestTimeoutPolicy = RequestTimeoutPolicyHelper.narrow(policyArray[n]);
                return requestTimeoutPolicy.value();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < policyArray.length) {
            if (policyArray[n2].policy_type() == 1330577413) {
                TimeoutPolicy timeoutPolicy = TimeoutPolicyHelper.narrow(policyArray[n2]);
                return timeoutPolicy.value();
            }
            ++n2;
        }
        return -1;
    }

    private static short getSyncScope(Policy[] policyArray) {
        int n = 0;
        while (n < policyArray.length) {
            if (policyArray[n].policy_type() == 24) {
                SyncScopePolicy syncScopePolicy = SyncScopePolicyHelper.narrow(policyArray[n]);
                return syncScopePolicy.synchronization();
            }
            ++n;
        }
        return 0;
    }

    private static short getLocationTransparency(Policy[] policyArray) {
        int n = 0;
        while (n < policyArray.length) {
            if (policyArray[n].policy_type() == 1330577414) {
                LocationTransparencyPolicy locationTransparencyPolicy = LocationTransparencyPolicyHelper.narrow(policyArray[n]);
                return locationTransparencyPolicy.value();
            }
            ++n;
        }
        return 1;
    }

    private static boolean getInterceptor(Policy[] policyArray) {
        int n = 0;
        while (n < policyArray.length) {
            if (policyArray[n].policy_type() == 1330577415) {
                InterceptorPolicy interceptorPolicy = InterceptorPolicyHelper.narrow(policyArray[n]);
                return interceptorPolicy.value();
            }
            ++n;
        }
        return true;
    }

    public RefCountPolicyList(Policy[] policyArray) {
        this.value = policyArray;
        this.retry = RefCountPolicyList.getRetry(policyArray);
        this.connectTimeout = RefCountPolicyList.getConnectTimeout(policyArray);
        this.requestTimeout = RefCountPolicyList.getRequestTimeout(policyArray);
        this.syncScope = RefCountPolicyList.getSyncScope(policyArray);
        this.locationTransparency = RefCountPolicyList.getLocationTransparency(policyArray);
        this.interceptor = RefCountPolicyList.getInterceptor(policyArray);
    }
}

