package org.trinet.util.magnitudeengines;

import org.trinet.jasi.*;
import org.trinet.util.EpochTime;

//public class JiggleMCA extends org.trinet.jasi.coda.MCA {
public class JiggleMCA extends MCA {


/** Variable indicating whether or not the object is valid.  It is false until
  the Config method of a derived class sets it to otherwise. */
  protected boolean bMagnitudeMethodObjectIsValid = false;

    public JiggleMCA(String propertyFileName, ChannelList channelList) {
        super();
        printOutputStreamHeader(System.out);  // standard rather than file
        initByProperty(propertyFileName);     // file with configuration settings for mca class
        setChannelList(channelList);          // note: if ChannelList map is null, creates map when findSimilarInMap invoked
        setMagAssociationDisabled(true);      // disable default MCA summary magnitude association with passed solution
        this.mca = this;                      // reference to self
    }

    public JiggleMCA()
    {
//      ConfigureMagnitudeMethod();
    }

    public void ConfigureMagnitudeMethod(int iConfigurationSource,
                                         String sConfigurationLocation,
                                         String sConfigurationSection
                                        )
    {
//      ConfigureMagnitudeMethod();
    }

    public void ConfigureMagnitudeMethod (String propertyFileName, ChannelList channelList) {
        printOutputStreamHeader(System.out);  // standard rather than file
        initByProperty(propertyFileName);     // file with configuration settings for mca class
        setChannelList(channelList);          // note: if ChannelList map is null, creates map when findSimilarInMap invoked
        setMagAssociationDisabled(true);      // disable default MCA summary magnitude association with passed solution
        this.mca = this;                      // reference to self
        bMagnitudeMethodObjectIsValid = true;
    }

    /** Calculate Mca from scratch by scanning the waveforms given in the waveformList.
    * Returns resulting Magnitude. If no Mca is possible (does not meet quality
    * standards) null is returned. */
    public Magnitude calcSummaryMag(Solution solution, java.util.Collection waveformList) {

     // The MCA code sets isStale=true. It shouldn't and I can't find where it does it
     // So, get stale state here and reset it when done.
     boolean wasStale = solution.isStale();

        // scan waveforms, calc individual channel mags
        int codaCount = calcChannelMag(solution, waveformList);

        solution.setStale(wasStale);
     if (codaCount < 1)   return null;        // got no coda data or error

        solution.setStale(wasStale);

        return calcSummaryMag(solution);
/*
        // get the resulting codas, bail if none
        Coda [] codaArray = currentSol.codaList.getArray();
        if (codaArray == null || codaArray.length < 1) {
        solution.setStale(wasStale);
           return null;         // shouldn't happen if coda data exists
        }

        // calc summary
     if (calcSummaryMag(codaArray)){
         solution.setStale(wasStale);
         return getSummaryMagnitude();   // success
     } else {
         solution.setStale(wasStale);
         return null;                    // failure
     }
*/
    }

    /** Recalc the summary mag using existing coda readings.
    * Don't rescan the time series. */
    public Magnitude calcSummaryMag(Solution solution) {

        Coda [] codaArray = solution.codaList.getArray();

        if (codaArray == null || codaArray.length < 1) {
//	    solution.setStale(wasStale);
      return null;         // shouldn't happen if coda data exists
        }

  // calcSummaryMag() sets isStale=true. It shouldn't and I can't find where it does it
  // So, get stale state here and reset it when done.
  boolean wasStale = solution.isStale();

     setSolution(solution); // must set the active solution i.e. currentSol for this instance
     if (calibrList == null)  initCalibrList(EpochTime.epochToDate(currentSol.datetime.doubleValue()));

  if (calcSummaryMag(codaArray)){
      solution.setStale(wasStale);
      return getSummaryMagnitude();
  } else {
      solution.setStale(wasStale);
      return null;
  }
    }

/** Number of waveforms time span eligible for coda calculation. */
    public int getEligibleCount() {
        return mca.eligibleCount;
    }

/** Index of waveform in list currently being processed. */
    public int getSolutionWaveformToProcessIndex() {
        return mca.solWaveformToProcessIndex;
    }

/** Name of channel currently being processed. */
    public String getProgressMessageChannelName() {
        return mca.progressMessageChannelName;
    }
}
