package org.trinet.util.graphics.task;
import java.sql.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import javax.swing.*;
import org.trinet.jasi.*;

/** Prototype for a Dialog having an AbstractTaskMonitorOptionPanel progress component. */
public class TaskMonitorOptionPaneDialog extends TaskMonitorButtonBoxDialog {
    public static final int HIDE_TYPE = 0;
    public static final int HIDE_STOP_TYPE = 1;
    public static final int START_STOP_CANCEL_TYPE = 2;

    protected int panelType = HIDE_TYPE;

    public TaskMonitorOptionPaneDialog() {
        super();
    }

/** Creates a TaskMonitorOptionPanel instance of the specified type.
  * @see #setPanelOptionType(int)
  * @returns null panel type is unknown.
*/
    protected AbstractTaskMonitorPanel createTaskMonitorPanel(AbstractMonitorableTask task) {
        switch (panelType) {
            case HIDE_TYPE:  
                return new TaskMonitorHideOptionPanel(task);
            case HIDE_STOP_TYPE:  
                return new TaskMonitorHideStopOptionPanel(task);
            case START_STOP_CANCEL_TYPE:  
                return new TaskMonitorStartOptionPanel(task);
            default:
                return null;
        }
    }

/** Sets the panel button options. Choices are specified by class attributes:
  * HIDE_TYPE, HIDE_STOP_TYPE, and START_STOP_CANCEL_TYPE.
  * Panel type must be set before invoking setTask(), otherwise type defaults to HIDE_TYPE.
*/
    public void setPanelOptionType(int type) {
        panelType = type;
    }
}
