package org.trinet.util.graphics.task;
import java.awt.*;
import java.beans.*;
import javax.swing.*; 

/**
  * Creates a task panel component containing a JOptionPane 
  * with  a "Stop" and an "Hide"  button. The "Stop" button
  * stops execution of a running task instance.
  * The "Hide" button disposes any enclosing dialog frame, but
  * a started task continues to run. 
  * The user must first start the task by invoking startTask()
  * which will make the component visible.
*/ 
public class TaskMonitorHideStopOptionPanel extends AbstractTaskMonitorOptionPanel {

    public TaskMonitorHideStopOptionPanel(AbstractMonitorableTask task) {
        super(task);
    }

/**
  * Task thread is controlled using JOptionPane  "Stop", options.
  * By default "Stop" option will stop task processing,
  * then dispose parent container if it is a dialog frame.
  * @see #addButtonControlPropertyChangeListener(PropertyChangeListener)
 */
    protected JOptionPane createOptionPane() {
        String [] stringOptions = { "Hide", "Stop"};
        final JOptionPane optionPane = 
            new JOptionPane( progressMeter,
                            JOptionPane.INFORMATION_MESSAGE,
                            JOptionPane.DEFAULT_OPTION,
                            null, stringOptions, stringOptions[0]);
        optionPane.addPropertyChangeListener(
            new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent e) {
                    String prop = e.getPropertyName();
                    if (isVisible() && (e.getSource() == optionPane)
                     && (prop.equals(JOptionPane.VALUE_PROPERTY) ||
                         prop.equals(JOptionPane.INPUT_VALUE_PROPERTY))) {
                        String value = (String) e.getNewValue();
                        if (value.equals("Stop")) {
                            stopTask();
                        }
                        else if (value.equals("Hide")) {
                            disposeDialog();
                        }
                        else {
                            System.out.println("Option UNKNOWN: " + value);
                        }
                    }
                }
        });
        return optionPane;
    }

}
