package org.trinet.jiggle;

import org.trinet.jasi.Amplitude;

import java.awt.*;
import org.trinet.util.graphics.ColorList;

/**
* A graphical marker to show where a phase is expected to lie. Its just a
* colored rectangle. 
*/

public class PhaseCue implements MarkerIF{

    // Default size of symbol in pixels
    final static int minWidth = 8;
    final static int minHeight= 8;

    int width  = minWidth;
    int height = minHeight;
    double widthSecs = 0.5;

    /** Position of the marker in pixel space. Centered on the calculated time and
    spanning the Y-dimension of the WFPanel or viewport. */
    Point pos = new Point();

    /** Amplitude represented by this flag. */
    double dtime;

    /** WFPanel where flag will be drawn. */
    WFPanel wfp;

    /** Current color of the flag. */
    Color color = ColorList.mint;   // set default;

    /**
     * Create an amplitude flag representing this Amplitude
     * to be displayed in this WFPanel.
     */
     public PhaseCue () {
     }

    /**
     * Create an amplitude flag representing this Amplitude
     * to be displayed in this WFPanel.
     */
     public PhaseCue (WFPanel wfp, double epochTime) {
        set(wfp, epochTime);
     }

     public void set (WFPanel wfp, double epochTime) {
        this.wfp = wfp;
        this.dtime = epochTime;
     }

       /** Set the marker color. */
       public void  setColor (Color color) {
          this.color = color;
       }

       /** Return the marker color. */
       public Color getColor() {
          return color;
       }

       /** Set the marker size. */
       public void setSize (Dimension dim) {
          width  = (int) dim.getWidth();
          height = (int) dim.getHeight();
       }
       /** Return the marker size. */
       public Dimension getSize() {
          return new Dimension (width, height);
       }

       public void setWidthSecs(double seconds) {
          widthSecs = seconds;
       }
       public double getWidthSecs() {
          return widthSecs;
       }
/*
 * Draw the PhaseCue in the Graphics window.
 */
    public void draw (Graphics g) {

     if (wfp == null) return;
     
	// MUST RECALC. THIS EVERY TIME BECAUSE FRAME MIGHT HAVE RESCALED!
	int x = wfp.pixelOfTime(dtime) ;

	// lookup origin's color code
//	color = wfp.wfv.mv.solList.getColorOf(amp.getAssociatedSolution());

	g.setColor(color);

     // this makes a filled rectangle centered on the given time. Its width is
     // 'width' and its height is the whole height of the WFPanel
     width = (int) (widthSecs * wfp.pixelsPerSecond);
     int halfWidth = width/2;

     g.fillRect(x-halfWidth, 0, width, wfp.getHeight());


    }

}

