package org.trinet.jdbc;
import java.util.*;
import java.sql.*;
import java.math.*;
import org.trinet.jdbc.*;
import oracle.jdbc.driver.*;

/**
 * Create one JDBC connection. Calling classes access this connection and its
 * Statment class as a static class. For multiple connections see JDBConnection.
 *
 * Example:     rs = JDBConn.sm.executeQuery(sql);
 * @see JDBConnect
 */
public class JDBConn {
    public static Connection conn;
    public static Statement sm;

    /** String to allow caller to show cause of error to the user. Needed
     *  because all exceptions are caught here and not passed along.*/
    static String status = "";

    // Null constructor
    public JDBConn() {}

    public JDBConn(String url, String driverName, String user, String passwd){
	createConnection(url, driverName, user, passwd);
    }

    public static Connection getConnection() {
	return conn;
    }

    public static void setConnection(Connection connection) {
	conn = connection;
    }

    public static Connection createDefaultConnection(String url, String driverName, String user, String passwd){
    	createConnection(url, driverName, user, passwd);
	return conn;
    }
    public static void createConnection(String url, String driverName, String user, String passwd){
        try {
//	    DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
            Class.forName(driverName);
	    // this is needed because if DriverManager.getConnection() throws an
	    // exception the OLD conn remains and there's no way to check failure
	    // unless this returns conn = null.
	    conn = null;
	    conn = DriverManager.getConnection(url, user, passwd);
	    conn.setAutoCommit(false);
	    sm = conn.createStatement();
	    status = "OK";
	}
	catch (ClassNotFoundException ex) {
            System.err.println("Cannot find the database driver classes.");
            System.err.println(ex);
	    status = ex.getMessage();
	}
	catch (SQLException ex) {
	    SQLExceptionHandler.handleException(ex, conn);
	    status = ex.getMessage();
	}
	catch (Exception ex) {
	    ex.printStackTrace ();
	    status = ex.getMessage();
	}
    }

    /** Return the status string of the last connection creation. */
      public static String getStatus () {
	return status;
      }
/** Returns a copy of connection object for the server driver of the host machine database.
* This is for server-side use only.
*/
    public static Connection createDefaultConnectionCopy() {
	try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
	    // this is needed because if DriverManager.getConnection() throws an
	    // exception the OLD conn remains and there's no way to check failure
	    // unless this returns conn = null.
	    conn = null;
	    conn = DriverManager.getConnection("jdbc:oracle:kprb:");
	    conn.setAutoCommit(false);
	    status = "OK";
	}
	catch (ClassNotFoundException ex) {
            System.err.println("Cannot find the database driver classes.");
            System.err.println(ex);
	    status = ex.getMessage();
	}
	catch (SQLException ex) {
	    SQLExceptionHandler.prtSQLException(ex);
	    status = ex.getMessage();
	}
	return conn;
    }

/** Returns the connection object for the server driver of the host machine database.
* This is for server-side use only.
*/
    public static Connection createDefaultConnection() {
	try {
	    OracleDriver odriver = new OracleDriver();
	    // this is needed because if DriverManager.getConnection() throws an
	    // exception the OLD conn remains and there's no way to check failure
	    // unless this returns conn = null.
	    conn = null;
	    conn = odriver.defaultConnection();
	    conn.setAutoCommit(false);
	    status = "OK";
	}
	catch (SQLException ex) {
	    SQLExceptionHandler.prtSQLException(ex);
	    status = ex.getMessage();
	}
	return conn;
    }
}

