package org.trinet.jasi;

/**
 * Title:        JASI - Java Abstract Seismic Interface
 * Description:  Default dbase for testing
 * Copyright:    Copyright (c) 2001
 * Company:      USGS
 * @author Doug Given
 * @version
 */

public class TestDataSource extends DataSource {

  static final byte b1[] = {99, 97, 108, 103, 115};
  static final String str1 = new String(b1);
  static final byte b2[] = {116, 114, 105, 110, 101, 116, 100, 98};
  static final String str2 = new String(b2);

  public TestDataSource() {
    this("k2");
  }

  public TestDataSource(String host) {
    this(host, host+"db");
  }

  public TestDataSource(String host, String dbasename) {
    super ("jdbc:oracle:thin:@"+host+".gps.caltech.edu"+":1521:"+ dbasename,
          "oracle.jdbc.driver.OracleDriver",
          str2, str1);

    this.setWriteBackEnabled(true);
    // tell the world via the static DataSource class
    DataSource ds = new DataSource(this.getConnection());
    ds.setWriteBackEnabled(true);
  }
  }