package org.trinet.jasi;

/**
 * Used to contain enumeration of recognized amplitude types.
 */

public class AmpType  {
    
    static int knt = 0;
    public static final int UNKNOWN	= knt++;
    public static final int WA		= knt++;
    public static final int WAS		= knt++;
    public static final int PGA		= knt++;
    public static final int PGV		= knt++;
    public static final int PGD		= knt++;
    public static final int WAC		= knt++;
    public static final int WAU		= knt++;
    public static final int VI2		= knt++;
    public static final int SP03	= knt++;
    public static final int SP10	= knt++;
    public static final int SP30	= knt++;
    public static final int ML100	= knt++;
    public static final int ME100	= knt++;
    public static final int EGY		= knt++;

    /* See NCDN parametric schema doc, column 'amptype' */
    private static String str[] = {
    "UNKNOWN",
    "WA",
    "WAS",
    "PGA",
    "PGV",
    "PGD",
    "WAC",
    "WAU",
    "VI2",
    "SP.3",	
    "SP1.0",	
    "SP3.0",	
    "ML100",	
    "ME100",	
    "EGY"
    };

    /** Return true if the passed amptype is already corrected and no static
    * correction should be applied. */
    public static boolean isCorrected (int ampType) {
        return isCorrected (getString(ampType));
    }

    /** Return true if the passed amptype is already corrected and no static
    * correction should be applied. */
    public static boolean isCorrected (String ampType) {
      return ampType.equalsIgnoreCase("WAC");   // add other corrected types here
    }
    
    /** Return a short string describing the amplitude type. Return blank string
     * if type value is not legal. */

    public static String getString(int type) { 

	if (isLegal(type)) return str[type];
	return  str[0];		// unknown
    }

    /** Return an 'int' matching the enumeration value given a short string
    describing the amplitude type.  Returns 0 if no match was found or if string
    = "UNKNOWN". */
    public static int getInt(String type) { 

	for (int i = 0; i < str.length; i++) {

	    if (type.equalsIgnoreCase(str[i])) return i;
	}

	return 0;
    }

    /** Return true if value is within legal range of enumeration list. */
    public static boolean isLegal(int type) {
	if (type > str.length || type < 0) return false;
	return true;
    }

    /** Return true if string is a legal enumeration type */
    public static boolean isLegal(String type) {
	return isLegal(getInt(type));
    }

    // ///////////////////////////////////////////////////////////////////
    // test
    /*
    public static void main (String args[]) 
    {
	System.out.println (" -- amp types --");

	for (int i = 0; i < str.length; i++) {

	    System.out.println (i +" "+getString(i) + "  "+ getInt(getString(i)) );
	}

	System.out.println (" WAU = "+ AmpType.WAU);
    }
    */
} // AmpType
