package org.trinet.eventpriority;

//import org.trinet.eventmatch.*;     // for CatEntry
import org.trinet.jasi.DataSource;
import java.util.*;
import java.sql.*;

public class EventPriority {

/** Given magnitude, origin time and quality for an event calculate the "priority"
* of the event. <p>
*
* The algorithm is:<br>
*
*/

    static double magFactor  = 5.0;
    static double ageFactor  = 1.0;
    static double qualFactor = 2.0;

    /** True if factors have been set from the dbase. */
    static boolean factorsSet = false;

    static final double SECS_PER_DAY = 86400.0;

    /** The database connection. */
    static Connection conn = null;

     public EventPriority() {
     }

    /** Option to set the dbase connection. If this is not called it will use
        default connection which is OK if you are internal to the dbase but not otherwise.

	@see: org.trinet.eventmatch.DbaseConnection
 */
    public static void setConnection (Connection connection) {

	conn = connection;
    }

    /**
     * Get the factor parameters from the database if they haven't been already. Will not
     reset time if they were set earlier.

     @see: resetFactors()

     Factors are kept in a table called:
<tt>
     EventPriorityParams
       (magnitudeFactor		number          NOT NULL,
	ageFactor		number          NOT NULL,
	qualityFactor		number          NOT NULL ) ;
</tt>
     */
public static void setFactors() {

    if (factorsSet) return;	// already done

    resetFactors();
}
    /**
     * Reread the factor parameters from the database. They are kept in a table called:
<tt>
     EventPriorityParams
       (magnitudeFactor		number          NOT NULL,
	ageFactor		number          NOT NULL,
	qualityFactor		number          NOT NULL ) ;
</tt>
     */
public static void resetFactors() {

    // use default if none defined
    if (conn == null) {
	Connection conn = DataSource.getConnection();
    }

    String sql = "Select * from EventPriorityParams";

    ResultSet rs;

    double score = 0.0;

    try {

	Statement stmt = conn.createStatement();

	rs = stmt.executeQuery(sql);

	rs.next() ;
	magFactor  = rs.getDouble("magFactor");
	ageFactor  = rs.getDouble("ageFactor");
	qualFactor = rs.getDouble("qualFactor");

	factorsSet = true;

	stmt.close();		//closes statement & resultset

      } catch (SQLException ex) {
	      ex.printStackTrace(System.out);
      }
}

    /** Return the priority of an event with this mag, origin time and quality. Mag is
        the event local magnitude, age is how old the event is in days, and
        quality is the event quality in the range of 0.0 to 1.0, 1.0 being the
        best.*/
     public static double getPriority (double mag, double originTime, double quality) {

	 // make sure factors have been set from the dbase table
	 setFactors();

	 /*
	     double xmag  = mag*magFactor;
	     double xage  = (1.0/(age+0.1))*ageFactor;
	     double xqual = 1.0/(quality+0.1)*qualFactor;
	 */
	 double safeMag = mag;
	 if (safeMag == 0.0) safeMag += 0.01;		// no /0 errors, please

	 double xmag  = (1.0/safeMag)      * magFactor;
	 double xage  = getAge(originTime) * ageFactor;
	 double xqual = quality            * qualFactor;

	 double prio = xmag + xage + xqual;

	 // debug
	 boolean debug = false;
	 if (debug) {
	     System.out.println (xmag + "  "+xage+"  "+xqual+ "      = "+ prio);
	 }


	 return prio;
     }


    /** Return the priority of the 'evid' in the dbase. Returns 0.0 if no such event.*/
/*
     public static double getPriority (long evid) {

	 CatEntry cat = CatEntry.getCatEntryByEvid(evid) ;

	 if (cat == null) return 0.0;

	 return getPriority (cat.mag, cat.ot, cat.quality);

     }
*/
/** Return the current GMT time in epoch seconds. */
    static double getCurrentTimeGMT () {

	TimeZone gmt = TimeZone.getTimeZone("GMT");	    // all internal work in GMT
	GregorianCalendar cal = new GregorianCalendar(gmt);

	// must distinguish between 'java.util.Date'  and 'java.sql.Date'
        java.util.Date date = cal.getTime();    // current epoch millisec
        return (double) date.getTime()/1000.0;  // current epoch sec (millisecs -> seconds)

    }

/** Given an origin time in epoch seconds, return its age in DAYS. */
    public static double getAge(double originTime) {
	return  (getCurrentTimeGMT() - originTime) / SECS_PER_DAY;
    }

// ///////////////////////////////////////////////////////
/*
     public static void main(String[] args) {

	 // test time

	 System.out.println("GMT = "+getCurrentTimeGMT());

        if (args.length <= 0) {

          System.out.println ("Usage: EventPriority [evid] ");
          System.exit(0);

        }
        // event ID
          Long val = Long.valueOf(args[0]);
          long evid = (long) val.longValue();

	  //     long evid = 9564897;
     CatEntry cat = CatEntry.getCatEntryByEvid(evid) ;

     System.out.println (cat.toString());
     System.out.println ("Priority = "+ getPriority(evid));
     }
*/
}
