package org.trinet.web;

import java.text.*;
import java.awt.*;
import java.util.*;
import java.io.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;


import org.trinet.jdbc.*;
import org.trinet.jasi.*;
import org.trinet.util.*;
import org.trinet.util.gazetteer.*;

//import org.trinet.jiggle.*;
import org.trinet.jiggle.MasterView;
//import org.trinet.jiggle.WFGroupPanel;

import Acme.JPM.Encoders.GifEncoder;

import org.trinet.waveserver.rt.WaveClient;

/**
 * Make a Gif for a tirgger
 * The file defaults to <ID>.gif
 */
public class SnapTrigger extends SnapShot
{

    public static String gifFile;

    static boolean showIt = false;
    //    static boolean showIt = true;

    // show picks as red lines but not the description flag
    static boolean showPhaseDescriptions = false;

    static boolean debug = true;
    //    static boolean debug = false;

    /** Default width/height for ONE trace */

    public Dimension singlePanelSize = new Dimension (640, 30);

    // max channels to plot, ever. This is a reaction to running out of memory
    // when trying top make a gif for a 239 channel trigger.
    static final int MAXSIZE = 180;

    public SnapTrigger () {

	super();
	setSinglePanelSize(singlePanelSize);
    }

    /**
     *
     */
    public Component makeViewOfTrigger (long evid,
				    int ntraces,
				    int maxSecs) {
	return makeViewOfTrigger (evid, ntraces, maxSecs, showPhaseDescriptions);
    }

    /**
     *
     */
    public Component makeViewOfTrigger (long evid,
				    int ntraces,
				    int maxSecs,
				    boolean showPhaseDescriptions) {

	// get trigger info for this evid
	TriggerTN trigger = new TriggerTN(evid);

	return makeViewOfTrigger (trigger, ntraces, maxSecs, showPhaseDescriptions);
    }
    /**
     *
     */
    public Component makeViewOfTrigger (TriggerTN trigger,
				    int ntraces,
				    int maxSecs,
				    boolean showPhaseDescriptions) {

	if (trigger == null) return null;

	// retreive the list of CTW's
       	ArrayList windowList = (ArrayList) trigger.getChannelTimeWindows();

	if (windowList == null || windowList.size() == 0) {
	   System.out.println ("No channels in trigger list!");
	   return null;
	}

	// TOO MANY, ONLY GET TRIGGERED CHANNELS
	if (windowList.size() > ntraces) {
	    System.out.print ("! Trigger too big, using only triggered channels.  "+
				windowList.size() +" -> ");
	    windowList = (ArrayList) trigger.getTriggeredChannelTimeWindows();
	    System.out.println (windowList.size());
	}

	// STILL TOO MANY, TRUNCATE
	if (windowList.size() > ntraces) {
	    System.out.println ("! Truncating "+windowList.size()+
				" channel event to "+ntraces+" channels.");
	    for (int i = ntraces; i < windowList.size(); i++) {
		windowList.remove(i);
		windowList.trimToSize();   // tidy up memory
	    }
	}

	mv = new MasterView();

	mv.solList.add(trigger.sol);
	mv.solList.setSelected(trigger.sol);

	mv.setLoadChannelData(true);
	mv.setWaveFormLoadMode(MasterView.LoadAllInForeground);

	mv.defineByTriggerChannelTimeWindowList(windowList);
	// set the location to the earliest trigger time
	Channel chan1  = trigger.getEarliestChannel().getChannelObj();
	chan1 = Channel.lookUp(chan1); // lookup location

	LatLonZ loc = chan1.latlonz;

	trigger.sol.lat.setValue(loc.getLat());
	trigger.sol.lon.setValue(loc.getLon());
	trigger.sol.depth.setValue(loc.getZ());

	mv.distanceSort();

	return makeView(mv, showPhaseDescriptions);

	}
    /**
     *
     */
    public Component makeGif (long id, int ntraces, int maxSecs, String outFile) {

    // trigger view
	Component view = makeViewOfTrigger (id, ntraces, maxSecs, showPhaseDescriptions);
	encodeGifFile (view, outFile);
	return view;

    }

    /**
     *
     */
    public boolean encodeGifFile (Component view, String gifFile) {

	if (view == null) return false;

	try {
	    // component must be in a frame for this to work
	    JFrame frame =  new JFrame();
	    frame.getContentPane().add( view );	    // add scroller to frame
	    frame.pack();

	    // Create an image (it will be blank)
	    if (debug) System.out.println
		    ("making image..."+view.getWidth()+"/"+ view.getHeight());

	    Image image = view.createImage(view.getWidth(), view.getHeight());

	    // get the graphics context of the image
	    if (debug) System.out.println ("getting graphics object...");
	    Graphics g = image.getGraphics();


	    // copy the frame into the image's graphics context
	    if (debug) System.out.println ("printing graphics object...");
	    view.print(g);

	    // open the output file
	    if (debug) System.out.println ("opening file...");
	    File file = new File(gifFile);
 	    FileOutputStream out = new FileOutputStream(file);


	    if (debug) System.out.println ("encoding...");

	    // create the encoder
	    GifEncoder encoder = new GifEncoder (image, out);

	    // encode it
	    encoder.encode();

	    if (debug) System.out.println ("Flushing...");

	    out.flush();
	    if (debug) System.out.println ("Close file...");
	    out.close();


	} catch (FileNotFoundException exc) {
	    System.err.println ("File not found: " + gifFile);
	    return false;
	} catch (IOException exc) {
	    System.err.println ("IO error: "+ exc.toString());
	    return false;
	} catch (OutOfMemoryError err) {
	    System.err.println ("Out of memory error: "+ err.toString());
	    return false;
	}

	return true;
    }


    // /////////////////////////////////////////////////////////////////////////////

    public static void main (String args[])
    {
	long evid = 0;

	if (args.length < 1)	// no args
	{
	  System.out.println ("Usage: SnapTrigger <evid> [ntraces] [max_secs] [waveServer-file] [out-file] [dbase-host] [dbase-name]");
	  System.out.println ("           defaults:  ["+ntraces+"] ["+maxSecs+
			      "] [none] [<evid>.gif] "+ host +" "+dbasename);
	  System.exit(-1);

	}

	// event ID
	Long l = Long.valueOf(args[0]);
	evid = (long) l.longValue();

	// # of traces
	if (args.length > 1) {
	  Integer val = Integer.valueOf(args[1]);
	  ntraces = (int) val.intValue();
	}

	// set absolute max
	if (ntraces > MAXSIZE) {
	    ntraces = MAXSIZE;
	    System.out.println ("<ntraces> exceeds max. allowed, setting to "+MAXSIZE);
	}

	// max. seconds to plot
	if (args.length > 2) {
	  Integer val = Integer.valueOf(args[2]);
	  maxSecs = (int) val.intValue();
	}

	// get data from waveServer?
	if (args.length > 3) {

	   waveServerFile = args[3];

	   // if wave server file is "" read from local files
	   if (!waveServerFile.equals("local")) {

	       System.out.println ("Get time series from waveServer: file = "+
				   waveServerFile);

	       WaveClient waveClient = null;

	       try {
		   // Make a WaveClient

		   System.out.println ("Creating WaveClient using: "+waveServerFile);

		   waveClient = new WaveClient(waveServerFile); // property file name

		   int nservers = waveClient.numberOfServers();
		   if (nservers <= 0) {
		       System.err.println("getDataFromWaveServer Error:"+
					  " no data servers specified in input file: " +
					  waveServerFile);
		       System.exit(-2);
		   }

	       }
	       catch (Exception ex) {
		   System.err.println(ex.toString());
		   ex.printStackTrace();
	       }

	       if (waveClient != null) Waveform.setWaveSource (waveClient);

	   }  // end of "if (!waveServerFile.equals(""))"

	} // end of "if (args.length > 3)"

	// destination .gif file
	gifFile = evid + ".gif";		//default
	if (args.length > 4) {
	    gifFile = args[4];
	}

	host = defaulthost;	// default
	if (args.length > 5) {
	    host = args[5];
	}

	dbasename = host+"db";	// default
	if (args.length > 6) {
	    dbasename = args[6];
	}

// -------------------------------------------------------

        System.out.println ("Making connection...");
	DataSource init = new TestDataSource(host, dbasename);  // make connection

	// Makes the .gif file, returns the grapical component in case you want
	// to display it below
	SnapTrigger snapTrigger = new SnapTrigger();
	Component view = snapTrigger.makeGif (evid, ntraces, maxSecs, gifFile);

// make a frame
	if (showIt && view == null) {

	    JFrame frame = new JFrame("SnapTrigger of "+evid);

	    frame.addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {System.exit(-3);}
	    });

	    frame.getContentPane().add( view );	    // add scroller to frame

	    frame.pack();

	    frame.setVisible(true);

	}

	// Return codes:
	if (view == null) {
	    System.err.println ("exit status = -1");
	    System.exit(-1);	// failure
	} else {
	    System.err.println ("exit status = 0");
	    System.exit(0);	// success
	}
    }


} // end of class
