package org.trinet.util.graphics.text;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import java.text.*;

public class NumberTextFieldFixed extends NumberTextField {

    public NumberTextFieldFixed(float value, int columns, DecimalFormat f) {
        this(new Double(value), columns, f);
    }

    public NumberTextFieldFixed(double value, int columns, DecimalFormat f) {
        this(new Double(value), columns, f);
    }

    public NumberTextFieldFixed(int value, int columns, DecimalFormat f) {
        this(new Long(value), columns, f);
    }

    public NumberTextFieldFixed(long value, int columns, DecimalFormat f) {
        this(new Long(value), columns, f);
    }

    public NumberTextFieldFixed(Object value, int columns, DecimalFormat f) {
/*
        super(columns);
        super.setDocument(new FormattedNumberDocument(f, columns));
        super.numberFormat = f;
        super.setValue(value);
*/
        this(columns, f);
        super.setValue(value);
    }

    public NumberTextFieldFixed(int columns, DecimalFormat f) {
        super(new FormattedNumberDocument(f, columns), columns, f);
    }

    public static void main(String [] args) {
	ActionListener al = new java.awt.event.ActionListener () {
	    public void actionPerformed(java.awt.event.ActionEvent evt) {
		System.out.println("test Evt command: " + evt.getActionCommand() + " src: " +
			 evt.getSource().getClass().getName());
		System.out.println("New value: " + ((NumberTextField) evt.getSource()).getText());
	    }
        };
	DecimalFormat df = (DecimalFormat) NumberFormat.getNumberInstance();
	df.setGroupingUsed(false);
	df.setDecimalSeparatorAlwaysShown(false);
	df.applyPattern("##0.##");
	df.setParseIntegerOnly(false);
	final NumberTextFieldFixed tf1 = new NumberTextFieldFixed(6, df);
        tf1.setLimits(new Double(-1000.), new Double(1000.)) ;
	tf1.setActionCommand("dbl-actn");
	tf1.addActionListener(al);
	tf1.setNullAllowed(false);
//	System.out.println("maxInt: " + df.getMaximumIntegerDigits());
//	System.out.println("maxFrac: " + df.getMaximumFractionDigits());


	DecimalFormat df2 = (DecimalFormat) NumberFormat.getNumberInstance();
	df2.setGroupingUsed(false);
	df2.setDecimalSeparatorAlwaysShown(false);
	df2.applyPattern("##0");
	df2.setParseIntegerOnly(true);
	final NumberTextFieldFixed tf2 = new NumberTextFieldFixed(3, df2);
        tf2.setLimits(new Integer(-10), new Integer(10));
	tf2.setActionCommand("int-actn");
	tf2.addActionListener(al);
	tf2.setDefaultValue(new Integer(5));
//	System.out.println("maxInt2: " + df2.getMaximumIntegerDigits());
//	System.out.println("maxFrac2: " + df2.getMaximumFractionDigits());


	Box box = Box.createHorizontalBox();
	box.add(Box.createGlue());
	box.add(tf1);
	box.add(Box.createHorizontalStrut(10));
	box.add(tf2);
	box.add(Box.createGlue());
	JPanel jp = new JPanel();
	jp.add(box);
        JFrame frame = new JFrame("NumberField");
        frame.addWindowListener(new java.awt.event.WindowAdapter() 
	{
            public void windowClosing(java.awt.event.WindowEvent e) {System.exit(0);}
        });

	JButton button = new JButton("Show Result");
	button.addActionListener(new java.awt.event.ActionListener()
	{
	    public void actionPerformed(java.awt.event.ActionEvent e) 
	    {
		System.out.println(tf1.getText());
		System.out.println(tf2.getText());
	    }
        });
	tf1.setValue(-123.23);
	tf2.setValue(1);
        frame.getContentPane().add("Center", jp);
        frame.getContentPane().add("South", button);
        frame.pack();
        frame.setVisible(true);
    }
}
