package org.trinet.util.graphics;

import java.awt.*;                                                                  
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import org.trinet.util.*;
//import com.borland.jbcl.layout.*;

/** a Component made up of two DateTimeChoosers for specifing a date/time range.
For use in dialogs. */
public class DateRangeChooser extends JPanel {

       static final String startLabelDef = "Start Time (UTC)";
       static final String endLabelDef   = "End Time (UTC)";

      String startLabel ;
      String endLabel ;

     JButton startDeltaButton   = new JButton();
     JButton endDeltaButton     = new JButton();
     JButton endZeroButton      = new JButton();
     JButton startZeroButton    = new JButton();

     /** Starting time. */
     DateTimeChooser startChooser ;

     /** Ending time. */
     DateTimeChooser endChooser ;

     JPanel endButtonPanel   = new JPanel();
     JButton nowButton       = new JButton();
     JPanel startButtonPanel = new JPanel();

/** Create a DateRangeChooser with default labels: "Start Time", "End Time"*/
     public DateRangeChooser() {
            this(startLabelDef, endLabelDef);
     }

/** Create a DateRangeChooser with default labels: "Start Time", "End Time"*/
     public DateRangeChooser(String startLabel, String endLabel, TimeSpan ts) {
            this(startLabelDef, endLabelDef);

            setTimeSpan(ts);
     }
/** Create a DateRangeChooser with the specified labels for start and end. */
     public DateRangeChooser(String startLabel, String endLabel) {

            this.startLabel = startLabel;
            this.endLabel = endLabel;

          try  {
               jbInit();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }

          // set default time
        DateTime now  = new DateTime();	// set time to now
        double endTime = now.getEpochSeconds();
        double hoursBack = 36.;
        double startTime = endTime - (60. * 60.0 * hoursBack);


          setTimeSpan(new TimeSpan(startTime, endTime));
     }

     /** Create the GUI*/
     void jbInit() throws Exception {

        // start panel
        JPanel startPanel = new JPanel();
        startChooser = new DateTimeChooser(startLabel);

          startPanel.setLayout(new BorderLayout());
          startDeltaButton.setText("Delta...");
          startDeltaButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    startDeltaButton_actionPerformed(e);
               }
          });

          nowButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    nowButton_actionPerformed(e);
               }
          });

          // zero button
          startZeroButton.setText("00:00:00");
          startZeroButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    startChooser.setTime(startChooser.getDateTime().getStartOfDay());;
               }
          });

//          startButtonPanel.setLayout(new BorderLayout());
          startButtonPanel.setLayout(new ColumnLayout());

          startButtonPanel.add(startDeltaButton);
          startButtonPanel.add(startZeroButton);

          startPanel.add(startChooser, BorderLayout.CENTER);
          startPanel.add(startButtonPanel, BorderLayout.EAST);

          // end panel
          JPanel endPanel   = new JPanel();
	     endChooser   = new DateTimeChooser(endLabel);

          endPanel.setLayout(new BorderLayout());
          endDeltaButton.setText("Delta...");
          endDeltaButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    endDeltaButton_actionPerformed(e);
               }
          });

          endZeroButton.setText("00:00:00");
          endZeroButton.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    endChooser.setTime(endChooser.getDateTime().getStartOfDay());;
               }
          });

          endButtonPanel.setLayout(new ColumnLayout());
          nowButton.setText("Now");

          endButtonPanel.add(endDeltaButton);
          endButtonPanel.add(endZeroButton);
          endButtonPanel.add(nowButton);

          endPanel.add(endChooser, BorderLayout.CENTER);
          endPanel.add(endButtonPanel, BorderLayout.EAST);


        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        add(startPanel);
        add(endPanel);

     }

     /** Enable/disable all the active components that make up this component.*/
     public void setEnabled (boolean tf) {
        startDeltaButton.setEnabled(tf);
        endDeltaButton.setEnabled(tf);
        nowButton.setEnabled(tf);
        startChooser.setEnabled(tf);
        endChooser.setEnabled(tf);
        startZeroButton.setEnabled(tf);
        endZeroButton.setEnabled(tf);
     }

     /** Set the start and end times of the chooser. */
     public void setTimeSpan (TimeSpan ts) {

            startChooser.setTime(ts.getStart());
            endChooser.setTime(ts.getEnd());
     }


     /** Return the time span selected in this chooser. */
     public TimeSpan getTimeSpan() {

            return new TimeSpan(startChooser.getEpochSeconds(),
                                endChooser.getEpochSeconds());

     }


     void startDeltaButton_actionPerformed(ActionEvent e) {
          DeltaTimeDialog dialog = new DeltaTimeDialog(null, "Time before end time", true);

          if ( dialog.getButtonStatus() == JOptionPane.OK_OPTION ) {
             double endTime = endChooser.getEpochSeconds();
             double time    = endTime - dialog.getSeconds();
             startChooser.setTime(time);
               // make sure its a legal time
              if (time < endTime) {   // OK
                startChooser.setTime(time);
              } else {
                 JOptionPane.showMessageDialog(null,
				      "Illegal time span.", "Date Range Error",
				      JOptionPane.INFORMATION_MESSAGE);
              }
          }
     }

     void endDeltaButton_actionPerformed(ActionEvent e) {
          DeltaTimeDialog dialog = new DeltaTimeDialog(null, "Time after start time", true);

          if ( dialog.getButtonStatus() == JOptionPane.OK_OPTION ) {

              double startTime = startChooser.getEpochSeconds();
              double time      = startTime + dialog.getSeconds();
              // make sure its a legal time
              if (time > startTime) {   // OK
                endChooser.setTime(time);
              } else {
                 JOptionPane.showMessageDialog(null,
				      "Illegal time span.", "Date Range Error",
				      JOptionPane.INFORMATION_MESSAGE);
              }

          }
     }

     void nowButton_actionPerformed(ActionEvent e) {
          double now = (new DateTime()).getEpochSeconds();

          endChooser.setTime(now);
     }
     
//  ////////////////////////////////////////////////////////
     public static void main(String[] args) {
        JFrame frame = new JFrame("DateRangeChooser");

        frame.addWindowListener(new WindowAdapter()
	   {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

        frame.getContentPane().add(new DateRangeChooser("Alpha", "Omega"));

        frame.pack();
        frame.setVisible(true);
     }
} 
