package org.trinet.storedprocs.ampassoc;
import java.sql.*;
import org.trinet.jasi.*;
import org.trinet.util.*;
import org.trinet.util.gazetteer.LatLonZ;  /// LatLonZ

 /** Associate a point in time for a given location with an event. */
public class PointAssociator {

  static final boolean debug = true;

  private static double searchTimeWindow = 120.0; // secs

  private static double windowSlop = 5.0; // increase time window size by this

//  static ampAssocModelIF assocModel;
  private static TravelTime ttModel = TravelTime.getInstance();

  /** Mag engine to calc ChannelMag as a test that the amp is consistent with
   *  the associated event.  */
  private static MagnitudeEngine magEng = new MagnitudeEngine(new SoCalML());

  private static Connection conn;

  public PointAssociator() {
  }
  public static void setSearchTimeWindow(double seconds) {
      searchTimeWindow = seconds;
  }
  public static double getSearchTimeWindow() {
      return searchTimeWindow;
  }
  /** Return the an associated event ID for this point in space/time.
   *  Returns 0 if no match. If more than one candidate event is found only
   *  the ID of the BEST fit is returned. */
  public static long getAssocEvent(double lat, double lon, double z,
				   double t0, double t1) {

      long matchID = 0;

// STEP #1: look for candidate events
    //search for origin times in this window
      double startTime = t0 - searchTimeWindow;
      double endTime   = t1;

      TimeSpan tsin = new TimeSpan(t0, t1);

      conn = makeConnection(); // this makes static method "standalone"

      // get candidate events
      SolutionList solList = new SolutionList();
      solList.setConnection(conn);
      solList.fetchValidByTime(startTime, endTime);

      if (debug) {
	System.out.println("Events found = "+   solList.size());
        for (int i = 0; i < solList.size(); i++ ) {
	  System.out.println(" "+ ((Solution) solList.get(i)).id.toString());
        }
      }
      if (solList.isEmpty()) return matchID;  // nothing

      LatLonZ llz = new LatLonZ(lat, lon, z);

      Solution sol;
      double closestfit = Double.MAX_VALUE;
      double distance = 0.0;
      double sDelta;  // difference between amp time and S-time (neg. if amp before S)
      double hotzone, ot;
      DoubleRange psrange;
      TimeSpan tsEvent;

// STEP #2: scan events for match
      for (int i = 0; i < solList.size(); i++ ) {
	 sol = (Solution) solList.get(i);
	 ot = sol.datetime.doubleValue();

	 distance = llz.distanceFrom(sol.getLatLonZ());

	 // tt model returns time relative to OT
	 psrange = ttModel.getTTps(distance);

	 double w0 = ot + psrange.getMinValue(); // P time
	 double w1 = ot + (2 * S-P

	 /////////////////////////////////////////////////

	 if (time < (psrange.getMinValue()+ot)) break;  // point before P-arrival

	 sDelta = (psrange.getMaxValue() + ot) - time ; // S - amp
	 sDelta = Math.abs(sDelta);

	 // TEST 1: is amp in the allowable window (hotzone)
	 // hotzone is S-P time + slop value
	 hotzone = psrange.doubleExtent() + windowSlop;   // S - P

	 if (debug) System.out.println("hotzone= "+hotzone+" sDelta = "+sDelta);
	 if (sDelta < hotzone) {    // within S-P either side of S-arrival
	    if (sDelta < closestfit) matchID = sol.getId().longValue();  // closer than closest
	 }
      }

      return matchID;
  }



  /** Return the an associated event ID for this point in space/time.
   *  Returns 0 if no match. If more than one candidate event is found only
   *  the ID of the BEST fit is returned. */
  public static long getAssocEvent(double lat, double lon, double z, double time) {

      long matchID = 0;

      // search for origin times in this window
      double startTime = time - searchTimeWindow;
      double endTime   = time;

      conn = makeConnection(); // this makes static method "standalone"

      // get candidate events
      SolutionList solList = new SolutionList();
      solList.setConnection(conn);
      solList.fetchValidByTime(startTime, endTime);

      if (debug) {
	System.out.println("Events found = "+   solList.size());
        for (int i = 0; i < solList.size(); i++ ) {
	  System.out.println(" "+ ((Solution) solList.get(i)).id.toString());
        }
      }
      if (solList.isEmpty()) return matchID;  // nothing

      LatLonZ llz = new LatLonZ(lat, lon, z);

      Solution sol;
      double closestfit = Double.MAX_VALUE;
      double distance = 0.0;
      double sDelta;  // difference between amp time and S-time (neg. if amp before S)
      double hotzone, ot;
      DoubleRange psrange;

      for (int i = 0; i < solList.size(); i++ ) {
	 sol = (Solution) solList.get(i);
	 ot = sol.datetime.doubleValue();

	 distance = llz.distanceFrom(sol.getLatLonZ());

	 // tt model returns time relative to OT
	 psrange = ttModel.getTTps(distance);

	 if (time < (psrange.getMinValue()+ot)) break;  // point before P-arrival

	 sDelta = (psrange.getMaxValue() + ot) - time ; // S - amp
	 sDelta = Math.abs(sDelta);

	 // TEST 1: is amp in the allowable window (hotzone)
	 // hotzone is S-P time + slop value
	 hotzone = psrange.doubleExtent() + windowSlop;   // S - P

	 if (debug) System.out.println("hotzone= "+hotzone+" sDelta = "+sDelta);
	 if (sDelta < hotzone) {    // within S-P either side of S-arrival
	    if (sDelta < closestfit) matchID = sol.getId().longValue();  // closer than closest
	 }
      }

      return matchID;
  }




  /**
   * Make a connection. If we are running in the context of the Oracle server,
   * make the "default" connection to the local environment. Otherwise, use
   * the hardwired info which is used for testing outside the server.
   */

    public static Connection makeConnection ()
    {
            // set the jasi universal connection object
      if (DataSource.getConnection() == null) {
	  DataSource.set(DbaseConnection.create());
      }
      return conn;
    }

  public static void main(String[] args) {

    //long id = 56998981;
    long evid = 12475624;

    makeConnection();

//    Amplitude amp = Amplitude.create().getById(id);

    AmpList ampList = Amplitude.create().getBySolution(evid);
    Amplitude amps[] = ampList.getArray();

 //      System.out.println(amp.toString());
 //      long evid = getAssocEvent(amp);
 //      System.out.println("Result: evid = "+ evid);

    for (int i = 0; i< amps.length; i++) {
       System.out.println(amps[i].toString());
//       long result = getAssocEvent(amps[i]);
       //Channel ch = amps[i].getChannelObj();
       //amp[i].setChannelObj(Channel.lookUp(amp[i].getChannelObj()));
       Channel ch = Channel.lookUp(amps[i].getChannelObj());
       LatLonZ llz = ch.latlonz;
       PointAssociator.setSearchTimeWindow(60.0);
       long result = PointAssociator.getAssocEvent(llz.getLat(), llz.getLon(), llz.getZ(),
			           amps[i].getTime());
       System.out.println("Result: evid = "+ result);
    }
  }
}