package org.trinet.jiggle;

import java.net.*;
import java.io.*;
import javax.swing.*;
import java.awt.event.*;

/** Gets current Jiggle version number from the home server and compares it to the
* given version string. */
public class VersionChecker {

     static final String homeAddress =
        "http://iron.gps.caltech.edu/trinet_tpp_doc/v1.5/";

     static final String defFile = "jiggleversion.html";

     static final String downloadAddress =
        homeAddress+"Jiggle.html";

     static String version = "unknown";
     static String address = homeAddress;
     static VersionChecker vc;

     public VersionChecker() {
        this (homeAddress);
     }

     public VersionChecker(String address) {

         this.address = address;

         try {
           URL url = new URL(address+defFile);

           BufferedReader in = new BufferedReader(
                               new InputStreamReader(
                               url.openStream()));

           version = (String) in.readLine();
           in.close();
         }
         catch (MalformedURLException ex) {}
         catch (IOException ex) {}

     }

     /** Return the URL of the Jiggle home server as a string. */
    public static String getAddress() {
       return address;
    }
     /** Return the URL of the Jiggle home server as a string. */
    public static String getDownloadAddress() {
       return downloadAddress;
    }
    /** Return the currently releases Jiggle version number. Returns "unknown"
    * if home URL cannot be reached. */
    public static String getVersion() {
      if (vc == null) {
        vc = new VersionChecker();
      }
      return version;
    }

    /** Returns true if 'thisVersion' matches the version found at the home web site.
    Assumes we're current and returns true if Jiggle home site cannot be reached. */
    public static boolean isCurrent(String thisVersion) {
       if (getVersion().equals("unknown")) return true;
       return getVersion().equals(thisVersion);
    }

    public static void main (String args[]) {
/*
        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
	   {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

        frame.pack();
        frame.setVisible(true);

*/
         String versionNumber  = "2001.05.11";

         if (!VersionChecker.isCurrent(versionNumber)) {
            String msg = "WARNING: Your version of Jiggle is out-of-date.\n"+
            "Download latest version "+VersionChecker.getVersion()+ " from:\n"+
            VersionChecker.getAddress() ;

           String title = "Jiggle Out of Date "+versionNumber;

 	      JOptionPane.showMessageDialog(null,
				      msg, title,
                          JOptionPane.WARNING_MESSAGE);
         }

    }
}