package org.trinet.jiggle;

import java.util.*;
import java.awt.*;
import java.text.*;

import org.trinet.jasi.Units;

/**
 * Observable "model" that passes changes to the cursor location in an ActiveWFPanel.

 * Model:	This class. <p>
 *
 * Controllers: <p>
 *   1) ActiveWFPanel <p>
 *
 * Views: <p>
 *   1) CursorLocPanel <p>
 */

public class CursorLocModel extends Observable
{

    ActiveWFPanel wfp;
    Point cursorLoc;

//    int units;
//    DecimalFormat format;

public CursorLocModel () {
}

/**
 * Set the new cursor loc; notify observers. Needs whole WFPanel because it
 * needs both the cursorLocation and a reference to timeOfPixel() for a
 * particular WFPanel, otherwise it couldn't convert pixel location to time/amp.
 */
public void set (ActiveWFPanel wfp, Point cursorLoc)
{
    this.wfp = wfp;
    this.cursorLoc = cursorLoc;

    setChanged();
    notifyObservers(this);   // pass wfv to observers
}
/** Returns a Point object specifying the x,y coordinates in pixels of the current
 cursor location. */
public Point getCursorLoc() {
  return cursorLoc;
}
/*
public void setUnits (int units, DecimalFormat format) {
  if (Units.isLegal(units)) {
    this.units = units;
    this.format = format;

    setChanged();
    notifyObservers("UNITS");

  }
}
*/
} // end of class
