package org.trinet.jiggle;

import java.awt.*;
import javax.swing.*;

/**
 * Overrides JViewport's paint() method to draw a phase picking "bomb sight" in
 * the center of the Viewport.
 */
public class BombSightViewport extends JViewport {

    Color bombSightColor = Color.green;
    boolean fireEvents = true;

public BombSightViewport() {
    // this means: just repaint area newly scrolled into view
    // should improve performance
//v1.3 only    setScrollMode(JViewport.BLIT_SCROLL_MODE);
}
public BombSightViewport(Color clr) {
    this();
    setBombSightColor(clr);
    setOpaque(false);  // prob unnecessary
}

public void paint (Graphics g) {

  // this also paints children including the viewport and its view
    super.paint(g);	// do normal Viewport paint

    // add the vertical "bombsite"
    int center = getWidth()/2 ;
    g.setColor (getBombSightColor());
    g.drawLine (center, 0 , center, getHeight() );

}

public void update (Graphics g) {
  paint(g);
}

/*  THIS DOEN'T WORK -- X-HAIR DOESN'T SHOW !!
public void paintComponent (Graphics g) {

    super.paintComponent(g);	// do normal Viewport paint

    // add the vertical "bombsite"
    int center = getWidth()/2 ;
    g.setColor (getBombSightColor());
    g.drawLine (center, 0 , center, getHeight() );

}
*/
/** Set the color of the vertical line in the bombsite. */
public void setBombSightColor (Color clr) {
  bombSightColor = clr;
}
/** Return the color of the vertical line in the bombsite. */
public Color getBombSightColor () {
  return bombSightColor;
}
/** Enable/disable firing of change events. */
public void enableChangeEvents(boolean tf) {
  fireEvents = tf;
}
/** Return true if firing of change events is enabled. */
public boolean changeEventsEnabled() {
  return fireEvents;
}
    /**
     * Overrides JViewport.fireStateChanged() to support disabling of
     * events via enableChangeEvents().
     * Notifies all <code>ChangeListeners</code> when the view's
     * size, position, or the viewport's extent size has changed if
     * enableChangeEvents() == true.
     *
     * @see JViewport.addChangeListener
     * @see JViewport.removeChangeListener
     * @see EventListenerList
     */
    protected void fireStateChanged(){
      if (changeEventsEnabled()) super.fireStateChanged();
    }
}

