package org.trinet.apps;

import java.awt.*;

import org.trinet.jiggle.*;
import org.trinet.jasi.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.Dimension;

import org.trinet.util.WaveClient;

/**
 * EventViewer.java
 * *
 * GUI for interactive viewing of waveforms and parameters for a single event.
 *
 * Created: Tue Nov  2 14:01:02 1999
 *
 * @author Doug Given
 * @version
 */

public class EventViewer {

    static boolean debug = true;
    //    static boolean debug = false;
    //    static boolean useWaveserver = true;
        static boolean useWaveserver = false;

    public EventViewer() {

    }


    public static void main (String args[])
    {
      // event 13307456 is a good test because it has no WF in 1st panel
      // 3113276 is an event from 1993
      // event 13692644 has PASA with Steim2 compression

  int evid = 152681;
  int channelsPerPage = 10;

  if (args.length <= 0)	// no args
  {
    System.out.println
    ("Usage: EventViewer <evid> [<channels/page>] (default= "+ channelsPerPage+")");
//test//	  System.exit(0);

  }

  if (args.length > 0) {

    Integer val = Integer.valueOf(args[0]);
    evid = (int) val.intValue();
  }

  if (args.length > 1) {

    Integer val = Integer.valueOf(args[0]);
    channelsPerPage = (int) val.intValue();

    if (channelsPerPage < 0 || channelsPerPage > 100) {
        System.out.println (" ! channels/page must be between 0 & 100.");
        System.exit(0);
    }
  }

        System.out.println ("Making connection...");
//	DataSource init = new TNDataSource();  // make connection
  DataSource init = new TestDataSource("makalu", "makaludb");  // make connection
//	DataSource init = new TNDataSource("iron", "irondb");  // make connection

  WaveClient waveClient = null;

  if (useWaveserver) {
      // cheating
      String propFile = "/home/tpp/www/waveserver.cfg";

      try {
    // Make a WaveClient

    System.out.println ("Creating WaveClient using: "+propFile);

    waveClient = WaveClient.CreateWaveClient().ConfigureWaveClient(propFile); // property file name

    //		System.out.println (waveClient.toString());

    int nservers = waveClient.numberOfServers();
    if (nservers <= 0) {
        System.err.println("getDataFromWaveServer Error:"+
           " no data servers specified in input file: " +
           propFile);
        System.exit(-1);
    }

      }
      catch (Exception ex) {
    System.err.println(ex.toString());
    ex.printStackTrace();
      }
      finally {
    //		if (waveClient != null) waveClient.close();
      }

      //
      Waveform.setWaveSource (waveClient);
  }


        if (debug) System.out.println ("Making MasterView for evid = "+evid);

  // Make the "superset" MasterView
  MasterView mv = new MasterView();

  int i = 0;
//        if (debug) System.out.println ("got to "+ i++);

  mv.setWaveFormLoadMode(MasterView.Cache);
  //mv.setWaveFormLoadMode(MasterView.LoadAllInForeground);

  int above = 50;
  int below = 50;
      mv.setCacheSize (above, below);

  //mv.setTimeAlign(true);
//     mv.setAlignmentMode(MasterView.AlignOnTime);
     mv.setAlignmentMode(MasterView.AlignOnTime);

  mv.defineByDataSource(evid);

  // get the first solution in the list
  //	Solution sol = (Solution) mv.solList.solList.get(0);
      Solution sol = null;
     if (mv.solList.size() > 0) {
     sol = (Solution) mv.solList.get(0);

        System.out.println ("SOL: "+sol.toString());
     System.out.println ("There are " + mv.getPhaseCount() +
          " phases, "+ mv.getWFViewCount() + " time series"+
                   " and "+mv.getAmpCount() + " amps");
     } else {
        System.out.println ("No dbase entry found for evid = "+evid);
        System.exit(0);
     }
// Make graphics components

  if (debug) System.out.println ("Creating GUI...");

  int height = 900;
  int width  = 640;

  //	VirtScroller wfScroller = new VirtScroller(mv, channelsPerPage, true);
  final WFScroller wfScroller = new WFScroller(mv, true) ;	    // make scroller

  // make an empth Zoomable panel
  ZoomPanel zpanel = new ZoomPanel(mv);

     // enable filtering, default will be Butterworth. See: ZoomPanel
     // Use zpanel.zwfp.setFilter(FilterIF) to change the filter
     zpanel.setFilterEnabled(true);

  // Retain previously selected WFPanel if there is one,
  // if none default to the first WFPanel in the list
     WFView wfvSel = mv.masterWFViewModel.get();
     // none selected, use the 1st one in the scroller
     if (wfvSel == null && mv.getWFViewCount() > 0) {
      wfvSel = (WFView) mv.wfvList.get(0);

      //////
      wfvSel.wf = null;     // crash
      //((WFView) mv.wfvList.get(3)).wf = null;  // no crash
      //////
     }

  // Must reset selected WFPanel because PickingPanel and WFScroller are
  // new and must be notified (via listeners) of the selected WFPanel.  It might
  // be null if no data is loaded.
     if (wfvSel != null ) {
       ((ActiveWFPanel)wfScroller.groupPanel.getWFPanel(wfvSel)).setSelected(true);
       mv.masterWFViewModel.set(wfvSel);
       mv.masterWFWindowModel.setFullView(wfvSel.getWaveform());
     }

  zpanel.setMinimumSize(new Dimension(300, 100) );
  wfScroller.setMinimumSize(new Dimension(300, 100) );

     ///////////    TEST //////////////////
     wfScroller.setSecondsInViewport(60.0);

  // make a split pane with the zpanel and wfScroller
  JSplitPane split =
      new JSplitPane(JSplitPane.VERTICAL_SPLIT,
         false,       // don't repaint until resizing is done
         zpanel,      // top component
         wfScroller); // bottom component

// make a main frame
  //        JFrame frame = new JFrame("SnapShot of "+evid);
        JFrame frame = new JFrame(sol.toSummaryString());

  String fileName = "JiggleLogo.gif";
  IconImage.setDebug(true);
  Image image = IconImage.getImage(fileName);
  frame.setIconImage(image);

        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });
     frame.getContentPane().add(split, BorderLayout.CENTER);	    // add splitPane to frame



//        SelectablePhaseList list = new SelectablePhaseList(mv);
//        frame.getContentPane().add(list, BorderLayout.SOUTH);



        frame.pack();
        frame.setVisible(true);

  frame.setSize(width, height);	// must be done AFTER setVisible

  // put divider at 25/75% position
  split.setOneTouchExpandable(true);
  split.setDividerLocation(0.25);

      //debug

     System.out.println ("++++++++++++++++++++++++++++++++++++++++++++++++++++");
     System.out.println ("WFView count        = "+ mv.getWFViewCount());
     System.out.println ("masterWFPanelModel  = "+ mv.masterWFViewModel.countListeners());
     System.out.println ("masterWFWindowModel = "+ mv.masterWFWindowModel.countListeners());
     System.out.println ("++++++++++++++++++++++++++++++++++++++++++++++++++++");

    }

} // EventViewer
