      FUNCTION DAYJL(JY,JM,JD)
C--RETURNS THE PERPETUAL JULIAN DAY RELATIVE TO JAN 1, 1960
C--FOR YEARS JY FROM 0 TO 99 (INCLUSIVE) IN THE 20TH CENTURY
C--OR YEARS JY LARGER THAN 1582.
C--THE JULIAN DAY ON JAN 1, 1960 AT 0H U.T. WAS 2436934.5,
C--BUT THIS FUNCTION RETURNS DAYJL (60,1,1) = 0.
      K=JY
      IF (K.LT.300) K=K+1900
      L=JM
      IF (L.GT.2) GOTO 10
      K=K-1
      L=L+12
10    A=365.25*(K-1960)
      I=.01*K
      B=30.6001*(L+1)
      DAYJL=AINT(A)+AINT(B)+(JD-I-48)+AINT(.25*I)
C--CORRECT DAY IF AINT TOOK THE INTEGER PART OF A NEGATIVE NO.
      IF (A.LT.0.) DAYJL=DAYJL-1.
      RETURN
      END
