package org.trinet.util.graphics.task;
import java.awt.*;
import java.beans.*;
import javax.swing.*; 

/**
  * Creates a task panel component containing a JOptionPane 
  * with  a "Hide"  button.  The "Hide" button disposes any
  * enclosing dialog frame, but a started task continues to run. 
  * The user must first start the task by invoking startTask()
  * which will make the component visible.
*/ 
public class TaskMonitorHideOptionPanel extends AbstractTaskMonitorOptionPanel {

    public TaskMonitorHideOptionPanel(AbstractMonitorableTask task) {
        super(task);
    }

/**
  * Returns a JOptionPane component containing the progress monitor.
  * Task thread is controlled using JOptionPane  methods.
  * By default "Hide" option dispose parent container if it is a dialog.
  * @see #addButtonControlPropertyChangeListener(PropertyChangeListener)
 */
    protected JOptionPane createOptionPane() {
        String [] stringOptions = { "Hide"};
        final JOptionPane optionPane = 
            new JOptionPane( progressMeter,
                            JOptionPane.INFORMATION_MESSAGE,
                            JOptionPane.DEFAULT_OPTION,
                            null, stringOptions, stringOptions[0]);
        optionPane.addPropertyChangeListener(
            new PropertyChangeListener() {
                public void propertyChange(PropertyChangeEvent e) {
                    String prop = e.getPropertyName();
                    if (isVisible() && (e.getSource() == optionPane)
                     && (prop.equals(JOptionPane.VALUE_PROPERTY) ||
                         prop.equals(JOptionPane.INPUT_VALUE_PROPERTY))) {
                        String value = (String) e.getNewValue();
                        if (value.equals("Hide")) {
                            disposeDialog();
                        }
                        else {
                            System.out.println("Option UNKNOWN: " + value);
                        }
                    }
                }
        });
        return optionPane;
    }
}
