package org.trinet.util.graphics.table;
import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.util.*;
import java.text.*;

public class TextCellRenderer extends DefaultTableCellRenderer {
  int fontSize=12;
  Font font;

  public TextCellRenderer() { 
    super();
    font = new Font("Monospaced", Font.PLAIN, fontSize);
    this.setFont(font);
    this.setHorizontalAlignment(JLabel.LEFT);
//    this.setToolTipText("Cell value must be text");
  }
  
  public TextCellRenderer(int fontSize) { 
    super();
    if (fontSize > 0) this.fontSize = fontSize;
    font = new Font("Monospaced", Font.PLAIN, fontSize);
    this.setFont(font);
    this.setHorizontalAlignment(JLabel.LEFT);
//    this.setToolTipText("Cell value must be text");
  }
  
  public TextCellRenderer(Font font) { 
    super();
    if (font != null) this.font = font;
    else this.font = new Font("Monospaced", Font.PLAIN, fontSize);
    this.setFont(font);
    this.setHorizontalAlignment(JLabel.LEFT);
//    this.setToolTipText("Cell value must be text");
  }
  
  public int getFontSize() {
    return fontSize;
  }

  public void setFontSize(int fontSize) {
    if (fontSize > 0) this.fontSize = fontSize;
    font = font.deriveFont((float) fontSize);
    this.setFont(font);
  }
 
}
    
