package org.trinet.util.gazetteer.TN;
import org.trinet.util.gazetteer.*;

import java.sql.*;
import java.util.*;

/** Every constructor and method assumes inputs are in units of decimal degrees and kilometers (depth or elevation).
*/
public abstract class WhereIsClosest extends WhereAmI {
    CallableStatement cs = null;

/** Default constructor does not set a database connection or the reference target point for gazetteer table data comparison.
*/
    WhereIsClosest() {
//	conn = JDBConn.createDefaultConnection();
    }

/** Constructor sets the database connection does not set the reference target point for gazetteer table data comparison.
*/
    WhereIsClosest(Connection conn) {
	super(conn);
    }

/** Constructor sets a database connection and the reference target point for gazetteer table data comparison.
*/
    WhereIsClosest(Connection conn, Geoidal reference) {
	super(conn, reference);
    }

/** Constructor the reference target point for gazetteer table data comparison, does not set a database connection.
*/
    WhereIsClosest(Geoidal reference) {
	super(reference);
    }

/** Constructor the reference target point for gazetteer table data comparison, does not set a database connection.
* Depth or elevation in assumed to be in kilometers units.
*/
    WhereIsClosest(double lat, double lon, double z) {
	super(lat, lon, z);
    }

    void closeStatement() {
	try { if (cs != null) cs.close();}
	catch (SQLException ex) {}
    }

/** Close the callable statement if object is garbage. */
    public void finalize() {
	try { if (cs != null) cs.close();}
	catch (SQLException ex) {}
    }

/** Implemented by subclasses of different gazetteer datatypes.*/
    abstract protected Vector getDatabaseData() ;

    protected Vector getDatabaseData(String sql) {
	Vector v = new Vector(1);
	try {
	    if (cs == null) {
		cs = conn.prepareCall(sql);
		cs.registerOutParameter(4, Types.DOUBLE);
		cs.registerOutParameter(5, Types.DOUBLE);
		cs.registerOutParameter(6, Types.DOUBLE);
		cs.registerOutParameter(7, Types.VARCHAR);
	    }
	    cs.setDouble(1, reference.getLat());
	    cs.setDouble(2, reference.getLon());
	    cs.setDouble(3, reference.getZ());
	    cs.executeUpdate();
	    WhereSummaryItem whereItem = 
		new WhereSummaryItem(cs.getDouble(4), cs.getDouble(5), cs.getDouble(6), cs.getString(7), null);
	    v.addElement(whereItem);
	}
	catch (SQLException ex) {
	    System.err.println(ex.getMessage());
	    ex.printStackTrace(System.err);
	    return null;
	}
	return v;
    }

}
