package org.trinet.util;

/**
  Static class that provides time unit information.
*/
public class TimeUnits {
     // LOGIC IN THIS CLASS DEPENDS ON ALL THE ARRAYS BEING CORRECTLY ALIGNED

     // don't do months because I don't want to deal with the complexity now.
     // Besides for a delta we don't know WHICH month we're measuring from.
     public static final String unitName[] = {"Second", "Minute", "Hour", "Day", "Week", "Year"};
     public static final String pluralUnitName[] = {"Seconds", "Minutes", "Hours", "Days", "Weeks", "Years"};

     static int k = 0;
     public static final int SECOND = k;
     public static final int MINUTE = k++;
     public static final int HOUR   = k++;
     public static final int DAY    = k++;
     public static final int WEEK   = k++;
     // no months, too variable
     public static final int YEAR   = k++;

     // second in each time unit (NOTE: year assumes 365 days/yr, :. leap year
     // are not handled correctly).
     public static final double secondsIn[] = {1.0, 60., 3600., 86400., 604800., 31536000.};

     TimeUnits() {
     }

     /** Return the number of seconds in the time unit described by the String
     * 'unit'. String comparison is NOT case sensitive. <p>
     *
     * Allowed units are "Second", "Minute", "Hour", "Day", "Week", "Year" and plural
     * forms "Seconds", "Minutes", "Hours", "Days", "Weeks", "Years" <br>
     * Note that 'month' is not supported because they are variable. Years is
     * assumed to be 365 days.
     *
     * If no match is found, zero is returned.
      */
     public static double getSecondsIn(String unit) {

            for (int i = 0; i < unitName.length; i++) {
               if (unit.equalsIgnoreCase(unitName[i]))
                  return secondsIn[i];
            }
            for (int i = 0; i < pluralUnitName.length; i++) {
               if (unit.equalsIgnoreCase(pluralUnitName[i]))
                  return secondsIn[i];
            }

            return 0.0;
     }
     /** Return the number of seconds in the time unit matching the 'unit' enumeration
     * value given.
     *
     * Allowed units are SECOND, MINUTE, HOUR, DAY, WEEK, YEAR
     * Note that 'MONTH' is not supported because they are variable. YEAR is
     * assumed to be 365 days.
     *
     * If no match is found, zero is returned.
      */
     public static double getSecondsIn(int value) {

            if (value > -1 && value <= secondsIn.length) {
               return secondsIn[value];
            }

            return 0.0;
     }
} 