package org.trinet.storedprocs.ampassoc;
/**
 * DbaseConnection.java
 *
 *
 * Created: Tue Feb  8 16:05:34 2000
 *
 * @author Doug Given
 * @version
 */
//import sqlj.runtime.ref.DefaultContext;
//import oracle.sqlj.runtime.Oracle;
import oracle.jdbc.driver.*;
import oracle.sql.*;
import java.sql.*;
import java.util.*;

public class DbaseConnection  {

    /** The dbase connection */
    static public Connection conn = null;


    private DbaseConnection() {

    }
  /**
   * Make a connection. If we are running in the context of the Oracle server,
   * make the "default" connection to the local environment. Otherwise, use
   * the hardwired info which is used for testing outside the server.
   */

    public static Connection create ()
    {

      if (conn != null) return conn;	// already a connection

      try {
	// not executing in server
	if (System.getProperty ("oracle.server.version") == null)
	  {
	    String driverName = "oracle.jdbc.driver.OracleDriver";
	    String url = "jdbc:oracle:thin:@k2.gps.caltech.edu:1521:k2db";

	    // TODO: get from a properties file?
	    // NOTE: changing this only affect command line modules and does
	    // not affect server modules.
	    String user = "trinetdb";
	    String passwd = "calgs";

	    Class.forName(driverName);
	    conn = DriverManager.getConnection(url, user, passwd);

        //System.out.println ("Making connection...");
	//DataSource init = new TNDataSource(host, dbasename);  // make connection

	  // executing in server
	  } else {
	    conn = new OracleDriver().defaultConnection();	// in server
	  }


      }
      catch (ClassNotFoundException ex) {
            System.err.println("Cannot find the database driver classes.");
            System.err.println(ex);
        }
  catch (SQLException ex) {
            ex.printStackTrace(System.out);
	}
        catch (Exception ex) {
            ex.printStackTrace ();
        }

	return conn;
    }

} // DbaseConnection
