package org.trinet.jiggle;

import java.applet.*; 
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.event.*;
import javax.swing.border.*;

/**
 * This component has two parts:<p>
 *  o A text label that describes the current action that's happening. <p>
 *  o A progress bar that shows the progress of the current action.<p>
 * It is used to show the progress of a time consuming opperation like
 * loading data. It is usually added to the MainStatusBar.

 */
public class StatusPanel extends JPanel {

       private JLabel statusLabel = new JLabel();
       private JProgressBar progressBar = new JProgressBar();

       static int min = 0;
       static int max = 100;

public StatusPanel ()
    {

      setLayout( new BoxLayout(this, BoxLayout.X_AXIS) );

// Text label
      statusLabel.setText("Status text shows here");
      add(statusLabel);

      statusLabel.setBorder(new EtchedBorder());
      statusLabel.setToolTipText("Shows current action.");

// progress bar
      progressBar.setOrientation(JProgressBar.HORIZONTAL);
      progressBar.setBorderPainted(true);
      progressBar.setStringPainted(true);
      progressBar.setPreferredSize(
        new Dimension(200, progressBar.getHeight()) );
      progressBar.setBorder(new EtchedBorder());
      progressBar.setToolTipText("Shows progress of slow actions.");

      this.setMinimumSize(new Dimension(100, 10));

      add(progressBar);

      clear();
      
//      add(Box.createGlue());

    } // end of createPanel


void reset (String str)
{
    statusLabel.setText(str);

    progressBar.setMinimum(min);
    progressBar.setMaximum(max);
    progressBar.setValue(min);
    progressBar.setForeground(Color.blue);
}
public void clear ()
{
    reset(" ");
}
/**
 * Set the progress bar value. A value of -1 means set to max value.
 */
public void setProgressBarValue (int val)
{

    if (val == -1) val = progressBar.getMaximum();

        progressBar.setValue(val);
        progressBar.validate();
//        progressBar.setString(val+"%");
}

public void setProgressBarValue (int val, String str)
{
    setProgressBarValue(val);
    setText(str);

}

public void setText(String str)
{
    statusLabel.setText(str);
    statusLabel.validate();
}


/**
 * Main for testing class
 * Note, needs:  import java.awt.event.*;
 */
    public static void main(String s[]) 
    {

        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter() 
	{
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });


        StatusPanel statusPanel =  new StatusPanel();
      frame.getContentPane().add(statusPanel);

      
        frame.pack();
        frame.setVisible(true);

        
      statusPanel.setText ("Starting");

      for (int i = 1; i<100; i++) {
       statusPanel.setProgressBarValue ( i, "counted to: "+i);

       try {
           Thread.sleep(100);
           } catch (InterruptedException ex) {}
      }

    }

 } // end of class


