package org.trinet.jasi.coda;
public abstract class CodaPhaseDescriptor implements Cloneable {
/** Type of coda measurement ('P', 'S', etc.) */
    private CodaType codaType;
/** Type of observed phase measured ('P', 'S', etc.) */
    private CodaType durationType;
/** Description of of observed phase's attributes (e.g. noise, truncation) */
    private String description;

    private boolean changed = false;

    protected CodaPhaseDescriptor(CodaType codaType, CodaType durationType, String description) {
        this.codaType = codaType;
        this.durationType = durationType;
        this.description = description;
    }
    public boolean hasChanged() { return changed;}
    public void setUpdate(boolean tf) { changed = tf;};
    public String getCodaType() { return codaType.getName();}
    public String getDurationType() { return durationType.getName();}
    public void setDurationType(CodaType type) {this.durationType = type;}
    public String getDescription() { return description;}
    public void setDescription(String description) {
        this.description = description;
        changed = true;
    }
    public boolean isSameType(CodaPhaseDescriptor cd) {
        return (this.codaType == cd.codaType && this.durationType == cd.durationType);
    }
    public String toString() {
        return "CodaType:" + codaType + " DurType:" + durationType + " Desc:" + description;
    }
    public boolean equals(Object codaDesc) {
        if (codaDesc == this) return true;
        if (codaDesc == null || ! (codaDesc instanceof CodaPhaseDescriptor)) return false;
        CodaPhaseDescriptor cd = (CodaPhaseDescriptor) codaDesc;
        if (isSameType(cd) && this.description.equals(cd.description) ) return true;
        return false;
    }

    public Object clone() {
        CodaPhaseDescriptor cd = null;
        try {
            cd = (CodaPhaseDescriptor) super.clone();
        }
        catch(CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        return cd;
    }
}

