package org.trinet.jasi;

/**
 * Used to contain enumeration of recognized units types.<p>
 *
 * Possible unit types:<p><tt>
 *
    "unknown"<br>
    "counts"<br>
    "seconds"<br>
    "mm"<br>
    "cm"<br>
    "m"<br>
    "m/sec"<br>
    "m/sec/sec"<br>
    "cm/sec"<br>
    "cm/sec/sec"<br>
    "mm/sec"<br>
    "mm/sec/sec"<br>
    "microns"<br>
    "ns"<br>
    "ergs"<br>
    "iovs"<br>
    "spa"<br>
 *</tt>
 */

public class Units  {
    
    static int i = 0;
    public static final int UNKNOWN	= i++;
    public static final int COUNTS	= i++;
    public static final int SECONDS	= i++;
    public static final int M		= i++;
    public static final int CM		= i++;
    public static final int MM		= i++;
    public static final int MS		= i++;	// m/sec
    public static final int MS2		= i++;	// m/sec2
    public static final int CMS		= i++;
    public static final int CMS2	= i++;
    public static final int MMS		= i++;
    public static final int MMS2	= i++;
    public static final int MICRONS	= i++;
    public static final int NM		= i++;	// nanometers
    public static final int ERGS	= i++;
    public static final int IOVS	= i++;	// intergral of vel. squared
    public static final int SPA		= i++;	// spectral peak amp
    public static final int CntCMS  = i++;
    public static final int CntCMS2  = i++;

    /* See NCDN parametric schema doc, column 'amptype' */
    private static String str[] = {
    "unknown",
    "counts",
    "seconds",
    "m",
    "cm",
    "mm",
    "m/sec",
    "m/sec^2",
    "cm/sec",
    "cm/sec^2",
    "mm/sec",
    "mm/sec^2",
    "microns",
    "ns",
    "ergs",
    "iovs",
    "spa",
    "counts/cm/sec",
    "counts/cm/sec^2"
     };

   
    /** Return a string describing the amplitude type. Returns the string "unknown"
	if the type is not legal. */
    public static String getString(int type) { 

	if (isLegal(type)) return str[type];
	return str[0];
    }

    /** Return an 'int' matching the enumeration value given a short string
    describing the amplitude type.  Returns 0 (=UNKNOWN) if no match was found. */
    public static int getInt(String type) { 

	for (int i = 0; i < str.length; i++) {

	    if (type.equalsIgnoreCase(str[i])) return i;
	}

	return 0;
    }

    /** Return true if value is within legal range of enumeration list. Note that a
     * value of 0 (=UNKNOWN) is legal.*/
    public static boolean isLegal(int type) {
	if (type > str.length || type < 0) return false;
	return true;
    }

    /** Return true if the string is a legal units string. Is NOT case sensitive.
    * Note that a value of "UNKNOWN" is legal.*/
    public static boolean isLegal(String type) {
     for (int i = 0; i < str.length; i++) {
       if (type.equalsIgnoreCase(str[i])) return true;
     }

     return false;
    }

} // AmpType
