package org.trinet.jasi;

import org.trinet.jdbc.datatypes.*;
import org.trinet.util.Format;		// CoreJava printf-like Format class

/**
 * Attributes of a magnitude for a single channel.
 *
 *
 * Created: Fri May 26 13:49:14 2000
 *
 * @author Doug Given
 * @version
 */

public class ChannelMag extends JasiObject {

    /** Corrected one-station mag for this amplitude for its associated solution. The
    * correction has already been added to this value. */
    public DataDouble value = new  DataDouble();

    /** The residual for this magnitude. It is calculated as: ChannelMag - EventMag. */
    public DataDouble residual = new  DataDouble();

    /** The importance of this amp to the summary magnitude (0.0 - 1.0).
    * Default = 0.0 */
    public DataDouble importance = new  DataDouble(0.0);
// *** This seems the same as weight. I'm not using it here.

    /** The correction for this magnitude. Added to calculated mag. Default = 0.0  */
    public DataDouble correction = new DataDouble(0.0);
 
    /** The weight for this magnitude. How much did this amp contribute to this magnitude?
    * Range is 0 to 1 Default = 0.0 */
    public DataDouble weight = new DataDouble(0.0);

    /** Magnitude type as the subscript to be appended to M. Like M<b>l<\b>.*/
    public DataString subScript = new DataString();

    /** */
    public ChannelMag() {

    }
    /*
    public void setWeight(double weight) {
	weight.setValue(weight);
    }
    public double getWeight () {
	return weight.doubleValue();
    }
    */

    /**
     *  Set the value of the Channel Magnitude
     */
    public void set (double magVal ) {

	value.setValue(magVal);

    }
    /** Returns 'true' if the value is null. */
    public boolean isNull() {
      return value.isNull();
    }
    /**
     * Set the channel's residual relative to this magnitude. It is calculated as:
     Observed - Calculated which is interpreted to mean ChannelMag - EventMag.
     This is consistent with phase pick residuals where a negative value means the
     observed pick is early relative to the model. A negative magnitude residual means
     the observed mag for this channel is smaller then the event mag.  */
    public void setResidual ( Magnitude mag ) {

    // There is a constraint error in the dbase that will not allow negative
    // residuals.  Last checked 1/3/2001 - still wrong
//	residual.setValue(value.doubleValue() - mag.value.doubleValue());
  	residual.setValue(Math.abs(value.doubleValue() - mag.value.doubleValue()));
    }

    public String toString() {

	return value +
	    " res: "+ residual +
//	    " imp: "+ importance +
	    " corr: "+ correction +
	    " wt: "+ weight+
         " type: M"+subScript;
    }

    /** */
    public String toNeatString() {

	Format df = new Format("%9.4f");	    // CORE Java Format class

	return df.form(value.floatValue()) + " " + 
	     df.form(residual.floatValue()) + " " + 
//	     df.form(importance.floatValue()) + " " +
	     df.form(correction.floatValue()) + " " + 
	     df.form(weight.floatValue()) ;

    }
    public static String getNeatStringHeader() {
//	return "   ChnlMag  Residual   Quality      Corr    Weight";
     //      xxxxxxxxx ......... xxxxxxxxx ......... xxxxxxxxx
	return "  ChnlMag  Residual      Corr    Weight";
    }
} // ChannelMag
