package org.trinet.web;

import javax.swing.*;
import java.awt.event.*;
import java.sql.*;
import java.util.*;

import org.trinet.jdbc.*;
import org.trinet.jdbc.datatypes.*;
import org.trinet.jdbc.table.*;
import org.trinet.jasi.*;

/**
 * Trigger.java
 *
 *
 * Created: Mon Oct 16 13:15:10 2000
 *
 * @author Doug Given
 * @version
 */

public class TriggerTN {

       public Solution sol;
       Connection conn = DataSource.getConnection();

       /** A colloction of TriggerChannelTimeWindow objects */
       ArrayList ctwList;

    /**
     *  Create a Solution object. DataSource must be established first.
     */
    public TriggerTN () {
	//	setConnection(DataSource.conn);	// use default connection

    }

    public TriggerTN (Solution sol) {
	  setSolution(sol);
    }

    public TriggerTN (long evid) {

	Solution sol = Solution.create().getById(evid);
	setSolution(sol);
    }

    /**
     *  Create a trigger object. DataSource must be established first.
     */
    public TriggerTN (Connection conn)
    {
	 setConnection(conn);
    }

    public void setConnection (Connection conn) {
      this.conn = conn;
    }

    public void setSolution (Solution sol) {
      this.sol = sol;

      //      System.out.println ("TriggerTN sol = "+sol.toString());
      ctwList = (ArrayList) getBySolution(sol);

      //      System.out.println ("ctwList size = "+ctwList.size());

    }

    /** Return the Collection of TriggerChannelTimeWindows for channels that
     * were triggered during this event trigger. This excludes channels that
     * were not triggered but were in triggered subnets. */
    public Collection getTriggeredChannelTimeWindows () {

	ArrayList tlist = new ArrayList();

	TriggerChannelTimeWindow ctw[] =
              (TriggerChannelTimeWindow[]) ctwList.toArray(new TriggerChannelTimeWindow[0]);

           if (ctw.length == 0) return tlist;

           for (int i = 0; i < ctw.length; i++) {
	       if (ctw[i].triggerTime != 0.0) tlist.add(ctw[i]);
	   }

       return tlist;
    }

    /** Return the Collection of TriggerChannelTimeWindows that go with this
    * trigger. This includes channels that were not triggered but were in
    * triggered subnets.  */
    public Collection getChannelTimeWindows () {
       return ctwList;
    }

    /** Return the TriggerChannelTimeWindow with the earliest trigger time.
    * If there are no trigger times the first TriggerChannelTimeWindow in the list
    * is returned. If there is no list, a virgin TriggerChannelTimeWindow is returned. */
    public TriggerChannelTimeWindow getEarliestChannel() {

           TriggerChannelTimeWindow ctw = new TriggerChannelTimeWindow();

           TriggerChannelTimeWindow array[] =
              (TriggerChannelTimeWindow[]) ctwList.toArray(new TriggerChannelTimeWindow[0]);

           if (array.length == 0) return ctw;

           double earliest = Double.MAX_VALUE;

           for (int i = 0; i < array.length; i++) {
             if (array[i].triggerTime != 0.0 &&
                 array[i].triggerTime < earliest) {
                     ctw = array[i];
                     earliest = ctw.triggerTime;
                 }
           }

      if (earliest == Double.MAX_VALUE) ctw = array[0];
      return ctw;
    }

    protected Collection getBySolution (Solution sol) {
	if (sol == null) return null;
	return getById (sol.id.longValue());
    }

    protected Collection getById (long evid) {

              String sql = "Select net, sta, seedchan, channel, channelsrc, location, "+
                  "auth, subsource, "+
                  "trigflag, datetime, savestart, saveend, rflag " +
                  " from Trig_Channel where ntid = " +
                  "(Select ntid from AssocNtE where evid = "+evid+ ") "+
                  " order by datetime ";

              return getBySQL( conn, sql );
    }

    /**
     * Returns a collection of ChannelTimeWindows for this triggered event
     * based on the entries in the 'trig_channel' table produce by the Earthworm
     * trigger program.  */
    protected Collection getBySQL(Connection connection, String sql)
    {

	ctwList = new ArrayList();


	// Debug
	//System.out.println ("getBYSQL(Connection, String) SQL\n: "+sql);

	try {

         if (connection == null) conn = DataSource.getConnection();

	    if ( connection.isClosed() )	// check that valid connection exists
		{
		    System.err.println ("* DataSource connection is closed");
		    return null;
		}

	    // ** Removed: don't use Oracle locking
	    // do "select for update" if writeBack is enabled
	    //	    ExecuteSQL.setSelectForUpdate(DataSource.isWriteBackEnabled());

	    Statement sm = connection.createStatement();

	    ResultSet rs = sm.executeQuery(sql);

	    while ( rs.next() ) {
		ctwList.add( parseResultSet(rs));
	    }

	    sm.close();

	}
	catch (SQLException ex) {
	    System.out.println ("getBYSQL(Connection, String) SQL=\n"+sql);
	    System.err.println(ex);
	    ex.printStackTrace();
	}

	return ctwList;
    }

/**
 * Parse a resultset row that contains the results of a join + some
 * stored procedures
 */
protected TriggerChannelTimeWindow parseResultSet (ResultSet rs)
{
	int offset = 0;

     TriggerChannelTimeWindow ctw;
	// parse the first part of the return
	ResultSetDb rsdb = new ResultSetDb(rs);
	// parse row contents into new channel object
	Channel ch = Channel.create();
 //  net, sta, seedchan, channel, channelsrc, location, "+
//   trigflag, datetime, savestart, saveend, rflag
	try {
            ch.setNet(rs.getString("NET"));
	    ch.setSta(rs.getString("STA"));
	    ch.setChannel(rs.getString("CHANNEL"));
	    ch.setAuth(rs.getString("AUTH"));
	    ch.setSubsource(rs.getString("SUBSOURCE"));
	    ch.setChannelsrc(rs.getString("CHANNELSRC"));
	    ch.setSeedchan(rs.getString("SEEDCHAN"));
	    ch.setLocation(rs.getString("LOCATION"));


         double start = rs.getDouble("savestart");
         double end   = rs.getDouble("saveend");

         ctw = new TriggerChannelTimeWindow(ch, start, end);

         ctw.triggerTime = rs.getDouble("datetime");
         ctw.triggerType = rs.getString("trigflag");

	}
	catch (SQLException ex) {
	    System.err.println(ex);
	    ex.printStackTrace();
         return new TriggerChannelTimeWindow(ch);
	}

	return ctw;
    }

 // ///////////////////////////////////////////////////////

    public static void main (String args[])
    {
        System.out.println ("Making connection...");
	DataSource init = new TestDataSource();  // make connection

	long evid = 9585741;

	System.out.println (" Getting trigger evid = "+evid);

	Solution sol = Solution.create().getById(evid);

	TriggerTN trig = new TriggerTN (sol);

     ArrayList list = (ArrayList) trig.getChannelTimeWindows();


	for (int i = 0; i<list.size(); i++)
        {
	    System.err.println (list.get(i).toString());
	}



    }

} // Trigger
