//Title:        util
//Version:
//Copyright:    Copyright (c) 1999
//Author:       Doug Given
//Company:      USGS
//Description:  Your description

package org.trinet.util.graphics;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.border.*;

import org.trinet.jasi.*;

/** A panel with check boxes that allows selection of various EventSelectionProperties
* attributes. */
public class EventSelectionFlagPanel extends JPanel {

     GridLayout gridLayout1 = new GridLayout();

     JPanel validFlagPanel = new JPanel();
     JPanel procStatePanel = new JPanel();
     JPanel eventTypePanel = new JPanel();

     JCheckBox validFlagCheckBox = new JCheckBox();
     JCheckBox dummyFlagCheckBox = new JCheckBox();
     JLabel    procStateLabel    = new JLabel();
     JComboBox procStateComboBox = new JComboBox();

     String str;  /// a working string

     // We will change the properties immediately, its up to the caller
     // to make sure it can recover from a cancellation.
     EventSelectionProperties props;

     /** The EventSelectionProperties object that is passed is changed
     * immediately by user action in the panel, therefore, if the caller wants
     * to be able to undo user action and revert to the old properties (say in
     * response to clicking a [CANCEL] button in a dialog) the caller must either retain
     * a copy of the original properties or pass a copy to this class and only
     * use it when approriate (say when [OK] is clicked). */
     public EventSelectionFlagPanel(EventSelectionProperties props) {

          this.props = props;

          try  {
               jbInit();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }
     }

     private void jbInit() throws Exception {
          this.setLayout(gridLayout1);
          gridLayout1.setColumns(1);
          gridLayout1.setRows(0);


// valid flag
          validFlagCheckBox.setText("Valid Flag Set");

          str = props.getProperty("validFlag");
          if (str != null)
              validFlagCheckBox.setSelected(str.equalsIgnoreCase("TRUE"));

          validFlagCheckBox.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    validFlagCheckBox_actionPerformed(e);
               }
          });

// dummy flag
          dummyFlagCheckBox.setText("Dummy Flag Set");

          str =props.getProperty("dummyFlag");
          if (str != null)
              dummyFlagCheckBox.setSelected(str.equalsIgnoreCase("TRUE"));

          dummyFlagCheckBox.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    dummyFlagCheckBox_actionPerformed(e);
               }
          });

          TitledBorder border2 = new TitledBorder("Validity Flags");
	     border2.setTitleColor(Color.black);
	     validFlagPanel.setBorder( border2 );

          validFlagPanel.add(validFlagCheckBox, null);
          validFlagPanel.add(dummyFlagCheckBox, null);
          this.add(validFlagPanel, null);

// event type

          TitledBorder border = new TitledBorder("Event Types");
	     border.setTitleColor(Color.black);
	     eventTypePanel.setBorder( border );

       /** List of event type choices which is defined in org.trinet.jasi.EventTypeMap. */
          String typeChoice[] = EventTypeMap.getEventTypeArray();

          for (int i = 0; i< typeChoice.length; i++)
          {
           JCheckBox jCheckBox = new JCheckBox(typeChoice[i]);

           // if property exists set initial state of check box
           str = props.getProperty(EventSelectionProperties.prefix+typeChoice[i]);
           if (str != null) {
             jCheckBox.setSelected(str.equalsIgnoreCase("TRUE"));
           }
           jCheckBox.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    eventType_actionPerformed(e);
               }
           });

           eventTypePanel.add(jCheckBox);
          }

          this.add(eventTypePanel, null);

// proc state

          TitledBorder border1 = new TitledBorder("Processing State");
	     border1.setTitleColor(Color.black);
	     procStatePanel.setBorder( border1 );

       /** List of event type choices which is defined in org.trinet.jasi.EventTypeMap. */
          String label[] = ProcessingState.getLabelArray();

          for (int i = 0; i< label.length; i++)
          {
           JCheckBox jCheckBox = new JCheckBox(label[i]);

           // if property exists set initial state of check box
           str = props.getProperty(EventSelectionProperties.prefix+label[i]);
           if (str != null) {
             jCheckBox.setSelected(str.equalsIgnoreCase("TRUE"));
           }
           jCheckBox.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    procState_actionPerformed(e);
               }
           });

           procStatePanel.add(jCheckBox);
          }

          this.add(procStatePanel, null);

     }

     void validFlagCheckBox_actionPerformed(ActionEvent e) {

       if ( validFlagCheckBox.isSelected() ) {
          props.setProperty ("validFlag",  "TRUE");
       } else {
          props.setProperty ("validFlag",  "FALSE");
       }

     }

     void dummyFlagCheckBox_actionPerformed(ActionEvent e) {

       if ( dummyFlagCheckBox.isSelected() ) {
          props.setProperty ("dummyFlag",  "TRUE");
       } else {
          props.setProperty ("dummyFlag",  "FALSE");
       }

     }

     void eventType_actionPerformed(ActionEvent e) {

          JCheckBox box = (JCheckBox) e.getSource();
          String type = box.getText();

          if (box.isSelected()) {
             props.setProperty(EventSelectionProperties.prefix+type, "TRUE");
          } else {
             props.setProperty(EventSelectionProperties.prefix+type, "FALSE");
          }

     }

     void procState_actionPerformed(ActionEvent e) {
          JCheckBox box = (JCheckBox) e.getSource();
          String type = box.getText();

          if (box.isSelected()) {
             props.setProperty(EventSelectionProperties.prefix+type, "TRUE");
          } else {
             props.setProperty(EventSelectionProperties.prefix+type, "FALSE");
          }
     }

     /** Return the modified EventSelectionProperties object. */
     public EventSelectionProperties getProperties () {
        return props;
     }
 ///////
     public static void main(String s[])
    {
             JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
	   {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

// Private properties
	   final EventSelectionProperties origProps = new EventSelectionProperties("eventProperties");

        origProps.dumpProperties();

        EventSelectionFlagPanel flagPanel =
                 new EventSelectionFlagPanel(origProps);


        JPanel panel = new JPanel(new BorderLayout());
        panel.add (flagPanel, BorderLayout.CENTER);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener() {

           public void actionPerformed(ActionEvent e) {
               System.out.println ("-- Event Selection Properties AFTER --");

               origProps.dumpProperties();

               System.out.println ("-----------");

           }
        });

        panel.add(okButton, BorderLayout.SOUTH);
        frame.getContentPane().add(panel);

//	   frame.setSize(200,30);	// this has no effect!
        frame.pack();
        frame.setVisible(true);
    }

}                                        
