package org.trinet.pcs;
public class SolutionProcessingResult {
    // Errors
    public static final SolutionProcessingResult FAILURE =
           new SolutionProcessingResult("FAILURE", -1);
    public static final SolutionProcessingResult UNKNOWN_PROCESSING_MODE =
           new SolutionProcessingResult("UNKNOWN_PROCESSING_MODE", -5);
    public static final SolutionProcessingResult NULL_INPUT =
           new SolutionProcessingResult("NULL_INPUT", -10);
    public static final SolutionProcessingResult INVALID_INPUT =
           new SolutionProcessingResult("INVALID_INPUT", -20);
    public static final SolutionProcessingResult INVALID_EVENT_ID =
           new SolutionProcessingResult("INVALID_EVENT_ID", -30);
    public static final SolutionProcessingResult INVALID_POSTING_RANK =
           new SolutionProcessingResult("INVALID_POSTING_RANK", -40);
    public static final SolutionProcessingResult DB_SQL_EXCEPTION =
           new SolutionProcessingResult("DB_SQL_EXCEPTION", -50);
    public static final SolutionProcessingResult UNKNOWN_ERROR_TYPE =
           new SolutionProcessingResult("UNKNOWN_ERROR_TYPE", -9999);

    //Success
    public static final SolutionProcessingResult INPUT_NOOP =
           new SolutionProcessingResult("INPUT_NOOP", 0);
    public static final SolutionProcessingResult NO_RESULTS_RETURNED =
           new SolutionProcessingResult("NO_RESULTS_RETURNED", 0);
    public static final SolutionProcessingResult UNIT_SUCCESS =
           new SolutionProcessingResult("UNIT_SUCCESS", 1);

    private String description;
    private int id;    
    protected SolutionProcessingResult(String description, int id) {
       this.description = description;
       this.id = id;
    }
    public int getIdCode() {
        return id;
    }
    public String getDescription() {
        return description;
    }
    public String toString() {
        return description + "=" + id;
    }
}
