package org.trinet.pcs;
import java.sql.*;

public abstract class AbstractJasiProcessingController extends AbstractProcessingController implements JasiProcessingControllerIF {

    protected JasiSolutionProcessorIF module; 

    protected AbstractJasiProcessingController () {}

    protected AbstractJasiProcessingController(String defaultGroupName, String defaultThreadName, String defaultStateName) {
        this(defaultGroupName, defaultThreadName, defaultStateName, DEFAULT_THREAD_SLEEP_MILLIS, null);
    }
    protected AbstractJasiProcessingController(String defaultGroupName, String defaultThreadName, String defaultStateName,
                                           int defaultSleepTimeMillis) {
        this(defaultGroupName, defaultThreadName, defaultStateName, defaultSleepTimeMillis, null);
    }
    protected AbstractJasiProcessingController(String defaultGroupName, String defaultThreadName, String defaultStateName,
                                           int defaultSleepTimeMillis, Connection connection) {
        this(new ProcessControlIdentifier(defaultGroupName, defaultThreadName, defaultStateName),
             defaultSleepTimeMillis,
             connection); 
    }

    protected AbstractJasiProcessingController(ProcessControlIdentifier pcId) {
        this(pcId, DEFAULT_THREAD_SLEEP_MILLIS, null);
    }
    protected AbstractJasiProcessingController(ProcessControlIdentifier pcId, int defaultSleepTimeMillis, Connection connection) {
        super(pcId, defaultSleepTimeMillis, connection);
        this.pcsCheckIdSQLString = PCS_CHECK_EVENT_ID_SQL_QUERY ;
        this.pcsGetPostIdsForDateRangeSQLString =  PCS_POST_EVENT_IDS_FOR_DATERANGE_PROCESSING ;
    }

    protected AbstractJasiProcessingController ( String defaultGroupName, String defaultThreadName, String defaultStateName,
                                                 int defaultSleepTimeMillis, Connection connection,
                                                 JasiSolutionProcessorIF module) {
        this(defaultGroupName, defaultThreadName, defaultStateName, defaultSleepTimeMillis, connection);
        setProcessingModule(module);
    }

    public void setProcessingModule(JasiSolutionProcessorIF module) {
         this.module = module;
    }
    public void setProcessingModuleMode(SolutionProcessingMode processingMode) {
        module.setSolutionProcessingMode(processingMode);
    }
    public int resultSolution(org.trinet.jasi.Solution solution, int resultCode) {
        return resultId(solution.id.longValue(), resultCode);
    }
    public int processSolution(org.trinet.jasi.Solution solution) {
        if (solution == null) return ProcessingResult.NULL_INPUT.getIdCode();
        else return resultSolution(solution, module.processSolution(solution));
    }
    public int processId(long eventId) {
        if (isValidId(eventId)) {
            return processSolution(org.trinet.jasi.Solution.create().getById(eventId));
        }
        else {
            return resultId(eventId, ProcessingResult.INVALID_ID.getIdCode());
        }
    }
}

