/* **********************************************************************
 *
 *  BBNT Solutions LLC, A part of GTE
 *  10 Moulton St.
 *  Cambridge, MA 02138
 *  (617) 873-2000
 *
 *  Copyright (C) 1998, 2000
 *  This software is subject to copyright protection under the laws of
 *  the United States and other countries.
 *
 * **********************************************************************
 *
 * $Source: /net/bitburg/u4/distapps/rcs/openmap/com/bbn/openmap/examples/hello/SimpleControl.java,v $
 * $Revision: 1.3 $
 * $Date: 2000/05/08 14:22:09 $
 * $Author: wjeuerle $
 *
 * **********************************************************************
 */

package org.trinet.map;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JButton;
import com.bbn.openmap.event.PanEvent;
import com.bbn.openmap.event.PanListener;
import com.bbn.openmap.event.PanSupport;
import com.bbn.openmap.event.ZoomEvent;
import com.bbn.openmap.event.ZoomListener;
import com.bbn.openmap.event.ZoomSupport;


/**
 * A sample control panel for the HelloWorld example.  This class
 * displays Zoom and Pan control buttons that manipulate the
 * map appropriately through the use of JavaBeans events.
 */
public class SimpleControl extends JComponent implements ActionListener {

    /** The pan north command string. */
    public static final String panNorthCmd = "PanNorth";

    /** The pan east command string. */
    public static final String panEastCmd = "PanEast";

    /** The pan south command string. */
    public static final String panSouthCmd = "PanSouth";

    /** The pan west command string. */
    public static final String panWestCmd = "PanWest";

    /** The zoom in command string. */
    public static final String zoomInCmd = "ZoomIn";

    /** The zoom out command string. */
    public static final String zoomOutCmd = "ZoomOut";

    /** The quit command string. */
    public static final String quitCmd = "Quit";

    /** Support for broadcasting zoom events. */
    protected ZoomSupport zoomHelper;

    /** Support for broadcasting pan events. */
    protected PanSupport panHelper;

    /**
     * Creates SimpleControl instance.
     */
    public SimpleControl () {

	// Create event helpers
	zoomHelper = new ZoomSupport(this);
	panHelper = new PanSupport(this);

	// Choose a layout manager
	setLayout(new FlowLayout());

	// Create the buttons
	add(createPanButtons());
	add(createZoomButtons());
	add(createQuitButton());
    }

    /**
     * Creates a button with the named command string.
     *
     * @param cmd the command string
     * @return a button
     */
    protected JButton createButton (String cmd) {

	// Make the button
	JButton btn = new JButton(cmd);

	// Wire up the event listener to catch presses
	btn.addActionListener(this);

	// return the button
	return btn;
    }

    /**
     * Creates a set of pan buttons.  The buttons are added to a box,
     * and that box is returned for incorporation into a parent
     * component.
     *
     * @return a component that contains the pan buttons
     */
    protected Box createPanButtons () {

	// Create a horizontal box, and add pan buttons
	// representing the four compass points to it
	Box box = Box.createHorizontalBox();
	box.add(createButton(panWestCmd));
	box.add(createButton(panNorthCmd));
	box.add(createButton(panSouthCmd));
	box.add(createButton(panEastCmd));
	return box;
    }

    /**
     * Creates a set of zoom buttons.  The buttons are added to a box,
     * and that box is returned for incorporation into a parent
     * component.
     *
     * @return a component that contains the zoom buttons
     */
    protected Box createZoomButtons () {

	// Create a horizontal box, and add a zoom in and a
	// zoom out button to it.
	Box box = Box.createHorizontalBox();
	box.add(createButton(zoomInCmd));
	box.add(createButton(zoomOutCmd));
	return box;
    }

    /**
     * Creates a quit button.  The button is added to a box, and that
     * box is returned for incorporation into a parent component.
     *
     * @return a component that contains the quit button
     */
    protected Box createQuitButton () {

	// Create a horizontal box, and add a zoom in and a
	// zoom out button to it.
	Box box = Box.createHorizontalBox();
	box.add(createButton(quitCmd));
	return box;
    }

    /**
     * Handles button presses by broadcasting appropriate events.
     *
     * @param e the action event to process
     */
    public void actionPerformed (ActionEvent e) {

	// grab the command for comparison
	String cmd = e.getActionCommand();

	// Figure out what the command was, and act appropriately
	if (cmd == zoomInCmd) {
	    zoomHelper.fireZoom(ZoomEvent.RELATIVE, .5f);
	} else if (cmd == zoomOutCmd) {
	    zoomHelper.fireZoom(ZoomEvent.RELATIVE, 2f);
	} else if (cmd == panNorthCmd) {
	    panHelper.firePan(PanEvent.NORTH);
	} else if (cmd == panEastCmd) {
	    panHelper.firePan(PanEvent.EAST);
	} else if (cmd == panSouthCmd) {
	    panHelper.firePan(PanEvent.SOUTH);
	} else if (cmd == panWestCmd) {
	    panHelper.firePan(PanEvent.WEST);
	} else if (cmd == quitCmd) {
	    System.exit(0);
	} else {
	    System.err.println("Unhandled action command: " + cmd);
	}
    }

    /**
     * Adds a zoom listener.  Simply delegates it to the
     * zoom helper instance.
     *
     * @param listener the listener to add
     */
    public void addZoomListener (ZoomListener listener) {
	zoomHelper.addZoomListener(listener);
    }

    /**
     * Removes a zoom listener.  Simply delegates it to the
     * zoom helper instance.
     *
     * @param listener the listener to remove
     */
    public void removeZoomListener (ZoomListener listener) {
	zoomHelper.removeZoomListener(listener);
    }

    /**
     * Adds a pan listener.  Simply delegates it to the
     * pan helper instance.
     *
     * @param listener the listener to add
     */
    public void addPanListener (PanListener listener) {
	panHelper.addPanListener(listener);
    }

    /**
     * Removes a pan listener.  Simply delegates it to the
     * pan helper instance.
     *
     * @param listener the listener to remove
     */
    public void removePanListener (PanListener listener) {
	panHelper.removePanListener(listener);
    }

}
