package org.trinet.jiggle;

import java.awt.*;
import java.text.*;
import java.util.*;
import java.math.*;

import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

import org.trinet.jasi.*;

import org.trinet.util.EpochTime;

/*
 * Make a small panel with text areas that display the current
 * currsor location in both time and amp units and cursor x/y.
 * Automatically adds itself as an observer
 * to the CursorLocModel.
 */
public class CursorLocPanel
		    extends JPanel
		    implements Observer  {
/* NOTE: Originally used JLabels not JTextFields but the setText()
 * method cause a repaint of the ZoomableWFPanel that flickered like hell.
 * I think the setText() method caused a validate that worked up the
 * component hierarcy causing the repaint.
 */

    // The strings set the initial size of the text fields
    JTextField timeField = new JTextField (" xx:xx:xx.xx ");
    JTextField ampField  = new JTextField(" -xxxxxx ", 8);

    JLabel timeLabel = new JLabel("Time =");
    JLabel ampLabel  = new JLabel("Counts =");

    JTextField xyField;
    JLabel xyLabel;

    String fontType = "Monospaced";
    int fontStyle   = Font.PLAIN;
    int fontSize    = 12;		// point

    Font font = new Font(fontType, fontStyle, fontSize);
    Color forgroundColor = Color.red;
    Color backgroundColor = Color.white;

//    DecimalFormat ampFormat = new DecimalFormat("######0");
    DecimalFormat ampFormat = new DecimalFormat("0"); // integer

    // option to include pixel XY field
    boolean includeXYfield = false;

/**
 * Constructor
 */
  public CursorLocPanel (CursorLocModel cursorLocModel) {

// the field objects
  if (includeXYfield) {
      xyField   = new JTextField (" XXXXX/YYYYY ", 10);
      xyLabel   = new JLabel("X/Y =");
      xyField.setForeground(forgroundColor);
      xyField.setBackground(backgroundColor);
      xyField.setEditable(false);
      xyField.setFont(font);
      xyField.setText(" XXXXX/YYYYY ");
      xyField.setMinimumSize(xyField.getSize());
  }

      timeField.setForeground(forgroundColor);
      timeField.setBackground(backgroundColor);
      timeField.setEditable(false);
      timeField.setFont(font);
      timeField.setText(" xx:xx:xx.xx ");
      //timeField.setMinimumSize(timeField.getSize());
      timeField.setMinimumSize(new Dimension (30, (int)timeField.getSize().getHeight()));

      ampField.setForeground(forgroundColor);
      ampField.setBackground(backgroundColor);
      ampField.setEditable(false);
      ampField.setFont(font);
      ampField.setText(ampFormat.format(0));
//      ampField.setMinimumSize(ampField.getSize());
      //ampField.setMinimumSize(new Dimension(50, 5));
      ampField.setMinimumSize(new Dimension (30, (int)ampField.getSize().getHeight()));

      // attempt to stop clipping the value in the window
	  //ampField.setMinimumSize(new Dimension(50, ampField.getHeight()));

      add (timeLabel);
      add (timeField);

      add (ampLabel);
      add (ampField);

      if (includeXYfield) {
	  add (xyLabel);
	  add(xyField);
      }

    // add self to static model
      cursorLocModel.addObserver(this);	     //MVC model
    }

    /** Set amp units and format. */
    public void setAmpFormat (int units, DecimalFormat format) {
         ampLabel.setText(Units.getString(units)+"=");
         ampFormat = format;
    }

    /** Set the amp units and format. Use the value to determine the format. */
    public void setAmpFormat (int units, double value) {

         // TODO: make custom format...
         // construct a format
         double test = Math.abs(value);
         if (test < 0.001) {
          ampFormat =  new DecimalFormat( "0.###E0" );
         } else if (test < 0.01) {
          ampFormat =  new DecimalFormat( "0.######" );
         } else if (test < 0.1) {
          ampFormat =  new DecimalFormat( "0.####" );
         }

         setAmpFormat(units, ampFormat);
    }

    public void setIncludXYfield(boolean tf) {
      includeXYfield = tf;
    }

    public boolean getIncludXYfield() {
      return includeXYfield;
    }

    /**
     * Model-View-Controller model. Note that the WFPanel class is both
     * Controller & View.
     */

    public void update (Observable obs, Object arg) {

	if (arg instanceof CursorLocModel ) {

	    setFields( (CursorLocModel) arg);
	}

    }

/**
 * Calc. the cursor position fields, need WFPanel for proper time decoding
 */
    void setFields (CursorLocModel model) {

	double epochSec  = model.wfp.dtOfPixel(model.getCursorLoc());
	double ampCounts = model.wfp.ampOfPixel(model.getCursorLoc());

/*        NOTE: the "S" format of SimpleDateFormat returns milliseconds
        * as an integer. This is prone to unexpected formatting results.
        * For example, if the seconds part of a time = 12.03456. the "ss.SS" format returns "12.34" and
        * "ss.SSSS" reuturns "12.0034". Only "ss.SSS" gives a correct result.*/
	//String str = EpochTime.epochToString (epochSec, "HH:mm:ss.SS");
	String str = EpochTime.epochToString (epochSec + 0.005, "HH:mm:ss.SSS");  // +0.005 to round
        str = str.substring(0, 11);     // lop off the last digit to get "HH:mm:ss.SS"
	timeField.setText(str);		// write result to field

	str = ampFormat.format(ampCounts);	// cheat to convert int -> string
	ampField.setText(str);		// write result to field

	// x,y field
	if (includeXYfield) {
	    str = " " + model.getCursorLoc().getX() + "/" + model.getCursorLoc().getY();
	    xyField.setText(str);		// write result to field
	}
    }

} // end of class
