package org.trinet.jasi;

import java.util.*;
import org.trinet.jdbc.*;
import org.trinet.jasi.*;
import org.trinet.util.*;

/**
 * This object defines a single channel/time-window.
 * The viewSpan (time bounds) of the view may be set arbitrarily by the caller
 * and is independent of the data that may actually be available.
 * Therefore, the viewSpan time window may
 * have no time series, be incomplete, or may clip a Waveform.<p>
 */

public class ChannelTimeWindow
{
    /** Channel description and info */
    Channel chan;

    /** The time window.*/
    TimeSpan viewSpan = new TimeSpan();

/**
 * Construct a nul view window.
 */
public ChannelTimeWindow ()
{
}

/**
 * Construct an empty view window.
 */
public ChannelTimeWindow (Channel ch)
{
    chan =  Channel.create();
    chan.setChannelObj(ch);
}
/**
 * Construct an empty view window with defined viewSpan time bounds.
 */
 public ChannelTimeWindow (Channel ch, double start, double end)
 {

     this (ch, new TimeSpan(start, end));

 }
/**
 * Construct an empty view window with defined viewSpan time bounds.
 */
 public ChannelTimeWindow (Channel ch, TimeSpan ts)
 {
     this (ch);
     viewSpan = new TimeSpan (ts);	// make new instance
 }

    // Channelable interface
    /**
     * Return the channel object associated with this reading.
     */
    public Channel getChannelObj () {
	return chan;
    }

    /** Set the Channel. */
    /* NOT IMPLEMENTED -> If defined, this object's chanList will be scanned for a matching
    * channel. If not defined, the MasterChannelList will be searched.
    * If a match is found, this Channel object is replaced by a reference to
    * the matching Channel object in the list. If no match is found, the
    * original Channel object is retained. This is done so that the readings
    * get the full channel description, lat/lon/z, response info, calibration,
    * distance from epicenter, etc. <p>
    * */
    public void setChannelObj(Channel channel) {
     chan = channel;
     // match the channel to the master list
/*     if ( MasterChannelList.get() != null) {
        setChannel(channel, MasterChannelList.get());
     }
*/
    }

/**
 * Set the viewSpan to the given value. This is used to align traces by
 * setting all their viewSpans equal.
 */
public void setViewSpan (TimeSpan ts) {
    viewSpan = new TimeSpan(ts);
}

public TimeSpan getViewSpan () {
       return viewSpan;
}

public double getStart() {
  return viewSpan.getStart();
}

public double getEnd() {
  return viewSpan.getEnd();
}

/**
 * Make sure the viewSpan includes the given value.
 */
public void viewSpanInclude (TimeSpan ts) {
    viewSpan.include(ts);
}

/**
 * Given a Collection of Channels (i.e. a station list), find the one that
 * matches this WFViews's current Channel. Replace the WFView's Channel object
 * with the "found" Channel which has complete Channel location & response info.
 * This is necessary for distance calcs, sorting, magnitudes, etc.  Return
 * 'true' if match was found, else return 'false'.  */
public boolean copyChannel(Collection chanList)
    {
	if (chanList == null) return false;

	Channel ch[] = new Channel[chanList.size()];
	chanList.toArray(ch);

	return copyChannel(ch);

    }
/**
 * Given an array of Channels (i.e. a station list), find the one that matches
 * this WFViews's current Channel. Replace the WFView's Channel object with the
 * "found" Channel which has complete Channel location & response info.  This is
 * necessary for distance calcs, sorting, magnitudes, etc.  Return 'true' if
 * match was found, else return 'false'.  */
public boolean copyChannel(Channel[] ch)
    {

	// VH_/EH_ kludge
	String origChan = chan.getChannel();

// No efficient way to do this unless we put Channel list in hash table
	for (int i = 0; i<ch.length; i++)
	{
	    if (chan.equalsIgnoreCase(ch[i])) {

		chan = ch[i];		// substitute

		// rest of the VH_/EH_ kludge
		//		System.out.println ("1) "+chan.toString());
		chan.setChannel(origChan);
		//		System.out.println ("2) "+chan.toString());

		return true;
	    }
	}
	return false;
    }

/**
 * Dump some info about the view for debugging
 */
public void dump ()
{
    System.out.println (toString());
}

/**
 * Dump some info about the view for debugging
 */
public String toString ()
{
    String str = "ChannelTimeWindow: "+ chan.toString() +
    " viewSpan = " + viewSpan.toString();

    return str;
}

} // end of class
