package org.trinet.util.graphics.table;

import org.trinet.jasi.*;
import org.trinet.jdbc.datatypes.*;

/** Define constants used by a CatalogTableModel. These are the columns in a
 *  JTable that contains a SolutionList. */
public interface CatalogTableConstants {
// Constant values used to identify respective data members in lists, access methods, or models.
    public static final int MAX_FIELDS         = 38;
    public static final int ID                 = 0;
    public static final int EXTERNALID         = 1;
    public static final int DATETIME           = 2;
    public static final int LAT                = 3;
    public static final int LON                = 4;
    public static final int DEPTH              = 5;
    public static final int HORIZDATUM         = 6;
    public static final int VERTDATUM          = 7;
    public static final int TYPE               = 8;
    public static final int METHOD             = 9;
    public static final int CRUSTMODEL         = 10;
    public static final int VELMODEL           = 11;
    public static final int AUTHORITY          = 12;
    public static final int SOURCE             = 13;
    public static final int GAP                = 14;
    public static final int DISTANCE           = 15;
    public static final int RMS                = 16;
    public static final int ERRORTIME          = 17;
    public static final int ERRORHORIZ         = 18;
    public static final int ERRORVERT          = 19;
    public static final int ERRORLAT           = 20;
    public static final int ERRORLON           = 21;
    public static final int TOTALREADINGS      = 22;
    public static final int USEDREADINGS       = 23;
    public static final int SREADINGS          = 24;
    public static final int FIRSTMOTIONS       = 25;
    public static final int QUALITY            = 26;
    public static final int VALIDFLAG          = 27;
    public static final int EVENTTYPE          = 28;
    public static final int PROCESSINGSTATE    = 29;
    public static final int DEPTHFIXED         = 30;
    public static final int LOCATIONFIXED      = 31;
    public static final int TIMEFIXED          = 32;
    public static final int WAVERECORDS        = 33;
    public static final int MAGNITUDE          = 34;
    public static final int PRIORITY           = 35; // added by aww 09/19/00 per DG request
    public static final int MAGTYPE            = 36; // added by aww 01/23/01 per DG request
    public static final int COMMENT            = 37; // added by ddg 01/22/02
// End of member identifier constants

    public static final Class [] columnClasses = {
        DataLong.class, DataString.class, DataDouble.class, DataDouble.class, DataDouble.class,
        DataDouble.class, DataString.class, DataString.class, DataString.class, DataString.class,
        DataLong.class, DataLong.class, DataString.class, DataString.class, DataDouble.class,
        DataDouble.class, DataDouble.class, DataDouble.class, DataDouble.class, DataDouble.class,
        DataDouble.class, DataDouble.class, DataLong.class, DataLong.class, DataLong.class,
        DataLong.class, DataDouble.class, DataLong.class, DataString.class, DataString.class,
	DataString.class, DataString.class, DataString.class, DataLong.class, Magnitude.class,
        DataDouble.class, String.class, String.class
    };

    public static final int [] columnFractionDigits = {
        0, 0, 5, 5, 5,
        3, 0, 0, 0, 0,
        0, 0, 0, 0, 1,
        2, 3, 4, 3, 3,
        5, 5, 0, 0, 0,
        0, 2, 0, 0, 0,
	0, 0, 0, 0, 0,
        1, 0, 0
    };

    public static final String [] columnNames = {
//        ID, EXTERNALID, DATETIME, LAT, LON,
//        DEPTH, HORIZDATUM, VERTDATUM, TYPE, METHOD,
//        CRUSTMODEL, VELMODEL, AUTHORITY, SOURCE, GAP,
//        DISTANCE, RMS, ERRORTIME, ERRORHORIZ, ERRORVERT,
//        ERRORLAT, ERRORLON, TOTALREADINGS, USEDREADINGS, SREADINGS,
//        FIRSTMOTIONS, QUALITY, VALIDFLAG, EVENTTYPE, PROCESSINGSTATE,
//	  DEPTHFIXED, LOCATIONFIXED, TIMEFIXED, WAVERECORDS, MAGNITUDE
//        PRIORITY,MAGTYPE
        "ID", "EXT_ID", "DATETIME", "LAT", "LON",
        "Z", "HDATUM", "VDATUM", "TYPE", "METHOD",
        "CMODEL", "VMODEL", "AUTH", "SRC", "GAP",
        "DIST", "RMS", "ERR_T", "ERR_H", "ERR_Z",
        "ERR_LAT", "ERR_LON", "OBS", "USED", "S",
        "FM", "Q", "V", "ETYPE", "ST",
	"ZFIX", "HFIX", "TFIX", "WRECS", "MAG",
        "PR", "MTYP", "COMMENT"
    };

    public static final boolean [] columnAKey = {
        true, false, false, false, false,
        false, false, false, false, false,
        false, false, false, false, false,
        false, false, false, false, false,
        false, false, false, false, false,
        false, false, false, false, false,
        false, false, false, false, false,
        false, false, false
    };

    public static final boolean [] columnEditable = {
        false, false, true, true, true,
        true, true, true, true, true,
        true, true, true, true, true,
        true, true, true, true, true,
        true, true, true, true, true,
        true, true, true, true, true,
        true, true, true, true, true,
        true, true, true
    };

    public static final boolean [] showColumn = {
//        ID, EXTERNALID, DATETIME, LAT, LON,
//        DEPTH, HORIZDATUM, VERTDATUM, TYPE, METHOD,
//        CRUSTMODEL, VELMODEL, AUTHORITY, SOURCE, GAP,
//        DISTANCE, RMS, ERRORTIME, ERRORHORIZ, ERRORVERT,
//        ERRORLAT, ERRORLON, TOTALREADINGS, USEDREADINGS, SREADINGS,
//        FIRSTMOTIONS, QUALITY, VALIDFLAG, EVENTTYPE, PROCESSINGSTATE,
//	  DEPTHFIXED, LOCATIONFIXED, TIMEFIXED, WAVERECORDS, MAGNITUDE
//        PRIORITY, MAGTYPE
        true, false, true, true, true,
        true, false, false, false, false,
        false, false, true, true, true,
        true, true, true, true, true,
        false, false, true, true, true,
        true, true, true, true, true,
        true, true, true, true, true,
        true, true, true
    };
}

