package org.trinet.util.graphics.table;
import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.util.*;
import java.text.*;

public class CalendarDateRenderer extends DefaultTableCellRenderer {
  protected DateFormat dateFormatter = DateFormat.getDateInstance();

  int fontSize=12;
  Font font;

  public CalendarDateRenderer() { 
    super();
    font = new Font("Monospaced", Font.PLAIN, fontSize);
    this.setFont(font);
    this.setHorizontalAlignment(JLabel.LEFT);
//    this.setToolTipText("Cell value must be a CalendarDate TimeStamp");
  }
  
  public CalendarDateRenderer(int fontSize) { 
    super();
    if (fontSize > 0) this.fontSize = fontSize;
    font = new Font("Monospaced", Font.PLAIN, fontSize);
    this.setFont(font);
    this.setHorizontalAlignment(JLabel.LEFT);
//    this.setToolTipText("Cell value must be a CalendarDate TimeStamp");
  }
  
  public CalendarDateRenderer(Font font) { 
    super();
    if (font != null) this.font = font;
    else this.font = new Font("Monospaced", Font.PLAIN, fontSize);
    this.setFont(font);
    this.setHorizontalAlignment(JLabel.LEFT);
//    this.setToolTipText("Cell value must be a CalendarDate TimeStamp");
  }
  
  public int getFontSize() {
    return fontSize;
  }

  public void setFontSize(int fontSize) {
    if (fontSize > 0) this.fontSize = fontSize;
    font = font.deriveFont((float) fontSize);
    this.setFont(font);
  }

  public void setValue(Object value) {
    if (value != null && value instanceof GregorianCalendar) {
	GregorianCalendar cal = (GregorianCalendar)value;
	super.setValue(dateFormatter.format(cal.getTime()));	
    }
    else
    {
	super.setValue(value); // default for java.sql.Timestamp
    }
  }
}
