
//Title:        util
//Version:      
//Copyright:    Copyright (c) 1999
//Author:       Doug Given
//Company:      USGS
//Description:  Your description

package org.trinet.util.graphics;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

import org.trinet.jasi.*;
import org.trinet.util.*;

public class EventSelectionTimePanel extends JPanel {

//     BorderLayout borderLayout1 = new BorderLayout();

     JPanel jPanelTop = new JPanel();
     JPanel jPanelBot = new JPanel();

//     Box hbox = Box.createHorizontalBox();

     JRadioButton rbuttonRelative = new JRadioButton();
     JRadioButton rbuttonAbsolute = new JRadioButton();

     /** Date range component */
     DateRangeChooser dateRangeChooser = new DateRangeChooser();
     /** Delta time component */
     DeltaTimePanel deltaTimePanel = new DeltaTimePanel();
     /** Radio button group */
     ButtonGroup buttonGroup = new ButtonGroup();

     /** Properties passed as an argument to the constructor */
     EventSelectionProperties props;

     public EventSelectionTimePanel(EventSelectionProperties props) {

          this.props = props;

          try  {
               jbInit();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }
     }

     /** GUI builder constructed by JBuilder design tool. */
     private void jbInit() throws Exception {

          this.setLayout(new BorderLayout());

          rbuttonRelative.setHorizontalTextPosition(SwingConstants.CENTER);
          rbuttonRelative.setVerticalTextPosition(SwingConstants.TOP);
          rbuttonRelative.setText("Relative Time");
          rbuttonRelative.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    rbutton_actionPerformed(e);
               }
          });
          rbuttonAbsolute.setHorizontalTextPosition(SwingConstants.CENTER);
          rbuttonAbsolute.setVerticalTextPosition(SwingConstants.TOP);
          rbuttonAbsolute.setText("Absolute Time");
          rbuttonAbsolute.addActionListener(new java.awt.event.ActionListener() {

               public void actionPerformed(ActionEvent e) {
                    rbutton_actionPerformed(e);
               }
          });

          // coordinate radio buttons so only one can be chosen at a time
          buttonGroup.add(rbuttonRelative);
          buttonGroup.add(rbuttonAbsolute);

          jPanelBot.add(rbuttonRelative);
          jPanelBot.add(new JPanel());  // spacer
          jPanelBot.add(deltaTimePanel);
          jPanelBot.setBorder(BorderFactory.createLineBorder(Color.black) );
          this.add(jPanelBot, BorderLayout.WEST);

          jPanelTop.add(rbuttonAbsolute);
          jPanelTop.add(dateRangeChooser);
          jPanelTop.setBorder(BorderFactory.createLineBorder(Color.black) );

          this.add(jPanelTop, BorderLayout.SOUTH);

          // set times to values in props
          dateRangeChooser.setTimeSpan(props.getTimeSpan());

          deltaTimePanel.setUnits(props.getProperty("relativeTimeUnits"));
          deltaTimePanel.setValue(props.getProperty("relativeTimeValue"));

          // Enable the initial mode as defined in the properties
        if (modeIsAbsolute()) {
             rbuttonAbsolute.doClick();
        } else {
             rbuttonRelative.doClick();
        }

     }

      /** Set the time span for the date range chooser. If the 'catalogTimeMode'
      * is "relative" this will be a timeSpan from now back to the length of
      * of the relative time interval. */
     public TimeSpan getTimeSpan() {

        if (modeIsAbsolute()) {
           return dateRangeChooser.getTimeSpan();
        } else {
          return deltaTimePanel.getTimeSpan();
        }

       // return new TimeSpan();
     }

     /** Return the length of the time span in seconds. */
/*     public double getDuration() {
       return getTimeSpan().getDuration();
     }
*/
/** The value specified  for the relative time*/
     public double getValue() {
       return deltaTimePanel.getValue();
     }
/** The units specified for the relative time */
     public String getUnits() {
        return deltaTimePanel.getUnits();
     }

     /** Return the modified EventSelectionProperties */
/*     public EventSelectionProperties getProperties() {
            return props;
     }
*/
     /** Returns a string describing the mode selected, relative or absolute. */
     public String getTimeMode() {
        return props.getProperty("catalogTimeMode") ;
     }

     /** Return 'true' if timemode is "absolute". */
     public boolean modeIsAbsolute() {
       return getTimeMode().equalsIgnoreCase("absolute");
     }

     /** Radio button action */
     void rbutton_actionPerformed(ActionEvent e) {

          if (rbuttonRelative.isSelected()) {
            props.setProperty("catalogTimeMode", "relative");

            dateRangeChooser.setEnabled(false);
            deltaTimePanel.setEnabled(true);
            deltaTimePanel.requestFocus();
            repaint();

          } else if (rbuttonAbsolute.isSelected()) {
            props.setProperty("catalogTimeMode", "absolute");

            dateRangeChooser.setEnabled(true);
            
            deltaTimePanel.setEnabled(false);
            dateRangeChooser.requestFocus();
            repaint();
          }
     }

      public EventSelectionProperties
             updateTimeProperties(EventSelectionProperties propsIn) {

        String mode = getTimeMode();
        propsIn.setProperty("catalogTimeMode", mode);

        if (mode.equalsIgnoreCase("absolute")) {
          propsIn.setTimeSpan(dateRangeChooser.getTimeSpan());
        } else if (mode.equalsIgnoreCase("relative")) {
          propsIn.setTimeWindow(deltaTimePanel.getValue(),
                              deltaTimePanel.getUnits());
        }
      return propsIn;

      }

 ///////
    /*
     public static void main(String s[])
    {

        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
	   {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });
// Private properties
	   EventSelectionProperties origProps = new EventSelectionProperties("eventProperties");

        origProps.dumpProperties();

        final EventSelectionTimePanel timePanel = new EventSelectionTimePanel(origProps);

        JPanel panel = new JPanel(new BorderLayout());
        panel.add (timePanel, BorderLayout.CENTER);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener() {

           public void actionPerformed(ActionEvent e) {

                 System.out.println ("-- Event Selection Properties AFTER --");

               timePanel.updateTimeProperties(origProps).dumpProperties();

               System.out.println ("-----------");

           }
        });

        panel.add(okButton, BorderLayout.SOUTH);
        frame.getContentPane().add(panel);

 //      dialog.getEventSelectionProperties().dumpProperties();

//	   frame.setSize(200,30);	// this has no effect!
        frame.pack();
        frame.setVisible(true);

    }
    */
}   
