package org.trinet.jiggle;

import org.trinet.jasi.Solution;
import org.trinet.jasi.PhaseList;

/**
 * Calculate a location using the remote location server.
 */

public abstract class LocationEngine
{

    /** The Original solution */
    Solution sol;

    /** Holds status message. */
    String message;

    /** Holds the raw output from the locator. */
    String outstr;

    PhaseList phaseList;	// list of phases used to do location

    /** String describing Name of locator Hypo2000, HypoElipse, GLASS */
    static String sLocatorName;

    /** True if current solution should be used as trial (beginning) location.
     *  Default is 'false'. */
    boolean useTrialLoc = false;

    boolean debug = true;

/** */
public LocationEngine()
{
}


  /* Real Construction Method */
  public static LocationEngine CreateLocationEngine(String sClassName)
  {
            LocationEngine newLocationEngine = null;

        try {
            newLocationEngine =  (org.trinet.jiggle.LocationEngine)Class.forName(sClassName).newInstance();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return newLocationEngine;
  }

/**
 * serverIPAddress has the form: "131.215.66.154" or "splat.gps.caltech.edu"
 */
/** Set the remote locationserver. If it is a change, reestablish a connection. */
public void setServer (String serverIPAddress, int serverPort)
{
}

/** Set the remote locationserver. If it is a change, reestablish a connection. */
public void setServer (String sPropertiesFile)
{
}

/** Clears out old solution message information. */
public void reset ()
{
}


/**
 * Calculate a solution given a Solution and an ArrivalList.
 * Returns true on success and false if phase list is emply.
 */
public boolean solve (Solution sol)
{
    this.sol = sol;
    return solve(sol.phaseList);
}


/**
 * Calculate a solution given a Solution and an ArrivalList.
 * Returns true on success and false if phase list is emply.
 */
public boolean solve (Solution sol, PhaseList phaseList)
{
    this.sol = sol;
    return solve(phaseList);
}

/**
 * Calculate a solution given an ArrivalList.
 * Returns true on success and false if phase list is emply.
 */
public boolean solve (PhaseList phaseList)
{
  return(false);
}

/**
 * Locate a given solution.
 */
public boolean Locate(Solution sol)
{
  return(solve(sol));
}


/** Returns a brief status message indicating the status of the location run.
 * Generally used for status bars, etc.*/
public String getMessage()
{
    return(message);
}

/** Return Raw(HypoInverse) style output for this location run. It will be multi-string
 * output with "\n" line separators. */
public String getResultString()
{
    return(outstr);
}

public void disconnect()
{

}

    /** Set 'true' if current solution should be used as trial (beginning) location.
     *  Default is 'false'. */
    public void setUseTrialLocation(boolean tf) {
      useTrialLoc = tf;
    }
    /** Returns 'true' if current solution will be used as trial (beginning) location.*/
    public boolean getUseTrialLocation() {
      return useTrialLoc;
    }

}  /* end of LocationEngine class */

