package org.trinet.jiggle;

import javax.swing.event.*;
import org.trinet.jasi.*;
import org.trinet.jasi.coda.*;

/** When an instance of this class is added as a listener to a JasiReadingList
* it keeps local JasiReadingLists for each WFView in the WFViewList in synch with
* the main list.
* There are three types of JasiReadingLists: PhaseList, AmpList, and CodaList.
* This is done with the WFViewList rather than making each WFView a listener for
* efficiency. We don't want to call 1,000 listeners when one reading changes. */
public class JasiReadingListModel implements ChangeListener {

     JasiReadingList readingList;
     WFViewList wfvList;

     public JasiReadingListModel ( WFViewList wfvList) {

       setWFViewList (wfvList);

     }

     /** Sets the WFViewList that will be updated in response to a JasiReading
     * change event. */
     public void setWFViewList (WFViewList wfvList) {

        this.wfvList = wfvList;

     }

     /** Respond to a list change. Update the appropriate list or lists. Tries to
     * minimize the work done. */
	public void stateChanged (ChangeEvent changeEvent) {

         Object obj = changeEvent.getSource();

         // a single reading
         if (obj instanceof JasiReading) {

            JasiReading src = (JasiReading) obj;      // cast to correct type
            WFView wfv = wfvList.get(src.getChannelObj());
            if (wfv != null) {
              if (src instanceof Phase) {
                 wfv.updatePhaseList();
              } else if (src instanceof Amplitude) {
                 wfv.updateAmpList();
              } else if (src instanceof Coda) {
                 wfv.updateCodaList();
              }
            }
         }

         // a list
         else if (obj instanceof JasiReadingList)  {

            JasiReadingList src = (JasiReadingList) obj;      // cast to correct type

	       WFView wfv[] = wfvList.getArray();

            if (wfv != null) {
              if (src instanceof PhaseList) {
	              for (int i = 0; i<wfv.length; i++)  {
	                  wfv[i].updatePhaseList();
                   }
              } else if (src instanceof AmpList) {
	              for (int i = 0; i<wfv.length; i++)  {
                       wfv[i].updateAmpList();
                   }
              } else if (src instanceof CodaList) {
	              for (int i = 0; i<wfv.length; i++)  {
                       wfv[i].updateCodaList();
                   }
              }
            }
     }
  }
}