package org.trinet.jasi.coda;
import org.trinet.jasi.*;
import org.trinet.jdbc.table.*;
import org.trinet.util.*;
import org.trinet.util.magnitudeengines.*;
import org.trinet.jasi.coda.*;
import org.trinet.jasi.coda.TN.*;
import org.trinet.jasi.TN.*;

/**
* Abstract type for a generic coda calibration for a station channel.
*/
public abstract class CodaCalibration extends ChannelParms {
    protected boolean verbose = true;        // for debugging print i/o
    protected boolean fromDbase = false;      // origin of the calibration data

    protected CodaCalibration() {}

    protected CodaCalibration(ChannelIdIF id) {
        super(id);
    }

    protected CodaCalibration(ChannelIdIF id, DateRange dateRange) {
        super(id, dateRange);
    }

    public static CodaCalibration create() {
        return create(DEFAULT);
    }

    public static CodaCalibration create(String className) {
        CodaCalibration retVal = null;
        try {
            retVal = (CodaCalibration) Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException ex) {
            System.err.println("CodaCalibration.create(classname): " + className);
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            System.err.println("Can't instatiate interface or abstract class.");
            System.err.println("CodaCalibration.create(classname): " + className);
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            System.err.println("CodaCalibration.create(classname): " + className);
            ex.printStackTrace();
        }
        return retVal;
    }

    public static final CodaCalibration create(int schemaType) {
      /***** DK Cleanup THIS CAN'T BE HERE
        if (schemaType == JasiFactory.TRINET) {
          //return McaCalibrationTN.create();  // this is infinitly recursive!
            return new McaCalibrationTN();
        }
        if (schemaType == JasiFactory.EARTHWORM) {
        }
      // Then why not depricate the method?? - DDG
        ******/
      return null;
    }

    public abstract CodaCalibrParms getCodaCalibrParms();
    public abstract CodaCalibrParms getDefaultCodaCalibrParms(ChannelIdIF chan);

}
