package org.trinet.jasi;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * Static classwith information about the application's environment including
 * the application name so that it can be set and accessed globally. Java does
 * not have the equivilent of C's arg[0] so the main application must identify
 * itself by calling setApplicationName() in this class so other classes can use
 * it.
 *
 * @author Doug Given
 * @version */

public class EnvironmentInfo {

/** The name of the application */
    private static String appName = "unknown";

    /** Then 2-char FDSN seismic network code. */
    private static String netCode  = "?";

    /** True if data is being produced automatically. False if by a human. */
    private static boolean automatic = true;

    private EnvironmentInfo() {

    }

    /** Set application name. */
    public static void setApplicationName(String str) {
	appName = str.trim();
    }

    /**  Get application name. */
    public static String getApplicationName () {
	return appName;
    }

    /** Convenience method returns user name. If unknown return "". This is not
        setable. */
    public static String getUsername () {
		  String userName = System.getProperty("JIGGLE_USER_NAME", "");
			if(userName.equals(""))
			  userName = System.getProperty("user.name", "");
		return(userName);
    }

    /** Convenience method returns Host name. If unknown return "". This is not
        setable. This returns form: "boron.gps.caltech.edu" */
    public static String getHostname () {
	try {
	    // This returns form: "boron.gps.caltech.edu/131.215.66.174"
	    //return InetAddress.getLocalHost().toString();

	    // This returns form: "boron.gps.caltech.edu"
	    return InetAddress.getLocalHost().getHostName();

	} catch (UnknownHostException ex) {
	    return "";
	}
    }
    /**
    * Return the 2-char FDSN network ID.
    */
    public static String getNetworkCode () {
      return netCode;
    }

    /**
    * Set the 2-char FDSN network ID. If the string is longer then 2 chars it
    * will be truncated. If it is shorter it will be padded with spaces.
    */
    public static void setNetworkCode (String str) {

      if (str.length() == 0) {
        netCode = "  ";
      } else if (str.length() == 1) {
        netCode = str + " ";
      } else {
        netCode = str.substring(0, 2);
      }
    }

    /** Set if automatic t/f. */
    public static void setAutomatic (boolean tf) {
      automatic = tf;
    }

    /** Returns true if automatic is set true. */
    public static boolean isAutomatic () {
      return automatic;
    }

    /** If 'automatic' is true return "A", if not return "H" (human) */
    public static String getAutoString() {

      if (automatic) return "A";
      return "H";
    }

    /** Return a summary string of the fields in this class. 
     * (can't call this 'toString()' because that conflicts with non-static method
     * in parent class. */
    public static String getString () {

	return "App: "+ appName + " Net: " + netCode + " automatic: "+automatic;
    }

} 
