// *** PACKAGE NAME *** \
package org.trinet.jasi.EW.SQL;


// *** IMPORTS *** \
import java.util.*;
import java.sql.Connection;
import java.sql.SQLException;
import org.trinet.jasi.EW.EWWaveform;


/**
 * <!-- Class Description>
 *
 *
 * Created:  2002/06/17
 *
 * @author   ew_oci2java Tool / DK
 * @version  0.99
 **/

public class GetWaveformStatement extends EWSQLStatement
{

  // *** CLASS ATTRIBUTES *** \

  // *** CONSTRUCTORS *** \
  public GetWaveformStatement()
  {
    sSQLStatement = new String("select binSnippet from Waveform where idWaveform = :IN_idWaveform");
    bIsQuery = true;
    init();
  }


  public GetWaveformStatement(Connection IN_conn)
  {
    this();
    SetConnection(IN_conn);
  }


  // *** CLASS METHODS *** \

  protected boolean SetInputParams(Object obj)
  {

    EWWaveform objEWWaveform = (EWWaveform)obj;

    try
    {
      cs.setLong(1, objEWWaveform.idWaveform);
    }
    catch (SQLException ex)
    {
      System.err.println("Exception in GetWaveformStatement:SetInputParams()");
      System.err.println(ex);
      ex.printStackTrace();
      return(false);
    }

    return(true);
  }   // end GetWaveformStatement::SetInputParams()


  protected boolean RetrieveOutputParamsList(Vector OutputObjectList)
  {

     EWWaveform objEWWaveform;

    try
    {
    while(rs.next())
    {
      objEWWaveform = new EWWaveform();

      // DK CLEANUP
      // we occasionaly get an error here, because Oracle has closed
      // the input stream for the snippet before we read it.
      // From http://otn.oracle.com/doc/oracle8i_816/java.816/a81354/basic4.htm#1002507
      // Also see http://www.oracle.com/forums/thread.jsp?forum=99&thread=145596&message=145596&q=6a6176612e73716c2e53514c457863657074696f6e3a2067657453747265616d4974656d2053747265616d2068617320616c7265616479206265656e20636c6f736564#145596
      /*
       Avoiding Streaming for LONG or LONG RAW

        The JDBC driver automatically streams any LONG and LONG RAW columns. However, there may be situations where you want to avoid data streaming. For example, if you have a very small LONG column, you might want to avoid returning the data incrementally and instead, return the data in one call.

        To avoid streaming, use the defineColumnType() method to redefine the type of the LONG column. For example, if you redefine the LONG or LONG RAW column as type VARCHAR or VARBINARY, then the driver will not automatically stream the data.

        If you redefine column types with defineColumnType(), you must declare the types of all columns in the query. If you do not, executeQuery() will fail. In addition, you must cast the Statement object to an oracle.jdbc.driver.OracleStatement object.

        As an added benefit, using defineColumnType() saves the driver two round trips to the database when executing the query. Without defineColumnType(), the JDBC driver has to request the datatypes of the column types.

        Using the example from the previous section, the Statement object stmt is cast to the OracleStatement and the column containing LONG RAW data is redefined to be of the type VARBINARAY. The data is not streamed--instead, it is returned in a byte array.

        //cast the statement stmt to an OracleStatement
        oracle.jdbc.driver.OracleStatement ostmt =
           (oracle.jdbc.driver.OracleStatement)stmt;

        //redefine the LONG column at index position 1 to VARBINARY
        ostmt.defineColumnType(1, Types.VARBINARY);

        // Do a query to get the images named 'LESLIE'
        ResultSet rset = ostmt.executeQuery
                 ("select GIFDATA from streamexample where NAME='LESLIE'");

        // The data is not streamed here
        rset.next();
        byte [] bytes = rset.getBytes(1);

     */


      objEWWaveform.RawSnippet=rs.getBytes(1);    // DK was binSnippet
      OutputObjectList.addElement(objEWWaveform);
    }  // end while(rs.next)
    }
    catch (SQLException ex)
    {
      System.err.println("Exception in GetWaveformStatement:RetrieveOutputParamsList()");
      System.err.println(ex);
      ex.printStackTrace();
      return(false);
    }

    return(true);
  }   // end GetWaveformStatement::RetrieveOutputParamsList()


} // end class GetWaveformStatement


//             <EOF>
