package org.trinet.apps;

import org.trinet.jiggle.*;
import java.text.*;
import java.awt.*;
import java.util.*;
import java.io.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

import org.trinet.jdbc.*;
import org.trinet.jasi.*;
import org.trinet.util.TimeSpan;
import org.trinet.util.gazetteer.LatLonZ;
//import org.trinet.trigger.*;

//import org.trinet.jiggle.*;
//import org.trinet.jiggle.MasterView;
//import org.trinet.jiggle.WFGroupPanel;

import org.trinet.util.WaveClient;

/**
 * Make a FreeSnap of the first 'n' channels with phase picks. <p>
 *
 *  Usage: FreeSnap [evid] [ntraces] [max_secs] [waveServer-file]
 *
 */
public class FreeSnap extends SnapShot
{
    public static MasterView   mv;	    // the master view

    public static final int NTRACES = 15;

    public static int ntraces = NTRACES ;

    public static int maxSecs = 120;
    public static String waveServerFile = "";

    //    static boolean debug = true;
    static boolean debug = false;

    public Dimension singlePanelSize = new Dimension (640, 60);

    public static String host;
    public static String dbasename;
    public static String defaultdbase = "k2db";

    static WaveClient waveClient = null;

    public static void main (String args[])
    {
  //	long evid = 9570828;	// Hector EQ (yikes!)
  long evid = 9552161;

  if (args.length <= 0)	// no args
  {
    System.out.println ("Usage: FreeSnap [evid] [waveServer-file] [dbase-name]");
    System.exit(0);
  }

  // event ID
  if (args.length > 0) {
    Long val = Long.valueOf(args[0]);
    evid = (long) val.longValue();
  }
  if (debug) System.out.println ("Using evid "+ evid);

  // get data from waveServer?
  if (args.length > 1) {

     waveServerFile = args[1];

     System.out.println ("Get time series from waveServer: file = "+
             waveServerFile);

     try {
         // Make a WaveClient

         System.out.println ("Creating WaveClient using: "+waveServerFile);

         waveClient = WaveClient.CreateWaveClient().ConfigureWaveClient(waveServerFile); // property file name

         int nservers = waveClient.numberOfServers();
         if (nservers <= 0) {
       System.err.println("getDataFromWaveServer Error:"+
              " no data servers specified in input file: " +
              waveServerFile);
       System.exit(-1);
         }

      }
     catch (Exception ex) {
         System.err.println(ex.toString());
         ex.printStackTrace();
     }

     if (waveClient != null) Waveform.setWaveSource (waveClient);

  }

  dbasename = defaultdbase;	// default
  if (args.length > 2) {
      dbasename = args[2];
  }

  host = dbasename.substring(0, dbasename.length()-2);  // hack off "db"
  System.out.println ("host = "+host);

        System.out.println ("Making connection...");
  DataSource init = new TestDataSource(host);  // make connection
  init.setWriteBackEnabled(true);

  // //////////////////////////////////////////////////////////////
  FreeSnap freeSnap =  new FreeSnap();
  Component view = freeSnap.makeView (evid);

  if (view == null) System.exit(0);

// make a frame

        JFrame frame = new JFrame("FreeSnap of "+evid);

  frame.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {System.exit(0);}
  });

  // scroller
        JScrollPane scroller = new JScrollPane();
  scroller.add(view);
  frame.getContentPane().add( scroller );	    // add scroller to frame

  frame.pack();
  frame.setVisible(true);

  int height = 900;
  int width  = 640;
  frame.setSize(width, height);	// must be done AFTER setVisible


  //	System.exit(0);

    }
    /**
     *
     */
   public Component makeView (long evid) {

      // Load the Solution
      Solution sol = Solution.create().getById(evid);
  if (sol == null) {
      System.out.println ("No such event: "+evid);
      return null;
  }

  if (waveClient == null) return null;

  System.out.println (sol.toString());

  System.out.println ("Reading in current channel info...");
        String compList[] = {"EH_", "HH_", "HL_", "AS_"};
      ChannelList chanList = ChannelList.getByComponent(compList);

  MasterChannelList.set(chanList);  // remember the list for later
  //ChannelList chanList = ChannelList.smartLoad();
  System.out.println ("Read "+chanList.size()+" channels.");

  SimpleChannelTimeModel model = new SimpleChannelTimeModel(sol, chanList);

  //ArrayList wfList = (ArrayList) model.getWaveformList();

  // test loading an event from this model
  MasterView mv = new MasterView();


  Waveform.setWaveSource(waveClient);
//	mv.setWaveFormLoadMode(MasterView.LoadAllInForeground);

// this loads readings, sorts and loads waveforms
  mv.setWaveFormLoadMode(MasterView.LoadNone);
  mv.defineByChannelTimeWindowModel(model);

  System.out.println ("mv has "+mv.wfvList.size()+" views.");

  mv.wfvList.trim(30);

  System.out.println ("mv has "+mv.wfvList.size()+" views.");

  // now read waveforms
  mv.setWaveFormLoadMode(MasterView.LoadAllInForeground);
  mv.loadWaveforms();

      return makeView(mv);

  }

    public void setSinglePanelSize (Dimension singlePanelSize) {

  this.singlePanelSize = singlePanelSize;
    }
} // end of class
