package org.trinet.util.graphics.task;
import java.util.*;
import org.trinet.jasi.*;

/**
  * Example of a progress monitable task for calculating
  * Ml magnitude in a background thread.
*/
public class MonitorableMlTask extends AbstractMonitorableTask {
    protected MagnitudeEngine magEng;
    protected Solution        solution;
    protected Collection      waveformList;
    protected ChannelList     chanList;

    public MonitorableMlTask (MagnitudeEngine magEng) {
        this("ML", magEng, null);
    }
    public MonitorableMlTask (MagnitudeEngine magEng, ChannelList chanList) {
        this("ML", magEng, chanList);
    }
    public MonitorableMlTask (String taskName, MagnitudeEngine magEng, ChannelList chanList) {
        super(taskName);
        this.magEng = magEng;
        setChannelList(chanList);
    }

    public void setChannelList(ChannelList chanList) {
        this.chanList = chanList;
        if (chanList != null) magEng.setChannelList(chanList);
    }

    public void configureMagEngine(double trimResidual, double minSNR, boolean useLowGains, boolean requireCorrections)  {
        MagnitudeMethod magMethod = magEng.getMagMethod();
        magMethod.setTrimResidual(trimResidual);
        magMethod.setMinSNR(minSNR);
        magMethod.setUseLowGains(useLowGains);
        magMethod.setRequireCorrection(requireCorrections);
    }

    public synchronized void setSolutionData(Solution solution, java.util.Collection waveformList) {
        this.solution     = solution;
        this.waveformList = waveformList;
    }

    // implementation of abstract method
    public synchronized Object doTask() {
        Magnitude result = magEng.solveFromWaveforms(solution, waveformList) ;
        setTaskComplete(true);
        return result;
    }

    public int getMinProgressValue() {
        return magEng.getMinProgressValue();
    }
    public int getMaxProgressValue() {
        int count = magEng.getMaxProgressValue();
        if (count > 0) {
            return maxProgressValue = count;
        }
        return (waveformList == null ) ? 0 : waveformList.size();
    }
    public int getCurrentProgressValue() {
        currentProgressValue = magEng.getCurrentProgressValue();
        return (currentProgressValue <= 0) ? 0 : currentProgressValue;
    }
    public String getProgressMessage() {
        String message = magEng.getProgressMessage();
        return (message == null) ? "No channels processed yet." : message +" "+ getCurrentProgressValue() +
               " of " + getMaxProgressValue();
    }
}
