package Tester;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import org.trinet.jasi.*;
import org.trinet.jasi.coda.*;
import org.trinet.util.graphics.task.*;

/** Example of progress monitorable Mc task using stand alone dialogs as a GUI. */
public class McaMonitorTester {
    static Solution sol;
    static Collection waveList;
    //static Magnitude magnitude;

    public static final void main(String [] args) {

        System.out.println("Creating new database connection");
        final DataSource dataSource = new DataSource(
        "jdbc:oracle:thin:@k2.gps.caltech.edu:1521:k2db",
        "oracle.jdbc.driver.OracleDriver",
        "trinetdb",
        "calgs"
        ); // use defaults

        try {

           System.out.println("Creating new mca thread group");
           final ThreadGroup jiggleThreadGroup = new ThreadGroup("JiggleMCA");
           jiggleThreadGroup.setDaemon(false);

        final int id = 10983128;  // a random test event

        // Let's create separate threads to get db info for event
        System.out.println("Creating new Solution.create().getById()");
        McaMonitorTester.sol = Solution.create().getById(id);

        //System.out.println(" Waiting for waveform db data");
        System.out.println("Creating new Waveform.create().getBySolutionId()");
        McaMonitorTester.waveList = Waveform.create().getBySolutionId(id);

// EXAMPLE progress bar monitor
        System.out.println("Waiting for channelList, loading to complete");
        // Now let's Load channelList by measured progress thread
        ChannelList channelList = null;
        MonitorableChannelListTask channelTask = 
            new MonitorableChannelListTask() {
                public void finished() {
                    System.out.println("Finished channelList load count: " + ((Collection) getTaskResult()).size()); 
                }
            };

        channelTask.setThreadGroup(jiggleThreadGroup);
        channelTask.setThreadName("ChannelList");
        channelTask.setProgressTimerDelay(100);

        TaskMonitorDialog channelDialog = new TaskMonitorDialog();
        channelDialog.setTask(channelTask);
        channelDialog.setProgressMeterVisible(true);
        channelDialog.setLocation(0,0);
        channelDialog.startTask();

        // System.out.println("MAIN: threads running: " + jiggleThreadGroup.activeCount()); //DEBUG
        //jiggleThreadGroup.list(); // DEBUG

        // block here til channel loading thread is done
        channelList = (ChannelList) channelTask.getTaskResult();

// EXAMPLE2 progress bar monitor
        //System.out.println("Created a solution the channelList and the waveformList, creating magnitude task ...");
        final MonitorableMcaTask mcaTask = 
            new MonitorableMcaTask("MCA_TEST", new JiggleMCA("MCA.properties", channelList)) {
                public void finished() {
                    //McaMonitorTester.magnitude = (Magnitude) getTaskResult();
                    //System.out.println("Finished mcaMag task: " + McaMonitorTester.magnitude.toString());
                    System.out.println(Magnitude.getNeatStringHeader());
                    System.out.println(jiggleMCA.getSummaryMagnitude().toNeatString());
                }
            };
        mcaTask.setThreadGroup(jiggleThreadGroup);
        mcaTask.setThreadName("MCA");
        mcaTask.setSolutionData(sol, waveList);
        mcaTask.setProgressTimerDelay(1000);

        System.out.println("Created a solution the channelList and the waveformList, creating task dialog ...");
        System.out.println("Starting mca calculation task ...");
        final JButton exitButton = new JButton("Exit");
        exitButton.addActionListener( new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                System.out.flush();
                dataSource.close();
                System.exit(0);
            }
        });
        JFrame mcaDialog = new JFrame("ProgressMonitor");
        TaskMonitorPanel mcaPanel = new TaskMonitorPanel(mcaTask);
        mcaPanel.add(exitButton);
        mcaDialog.setContentPane(mcaPanel);
        mcaDialog.setBounds(50,100,100,100);
        mcaDialog.pack();
        mcaDialog.show();
        mcaPanel.startTask();
        } // all of main is in try
        catch (Exception ex) { 
            ex.printStackTrace();
            dataSource.close();
            System.exit(0);
        }
    }
}
