package org.trinet.util.graphics.task;
import javax.swing.event.*;

/** Event generated by task progress monitors such as in the concrete 
  * subclasses of AbstractTaskMonitorPanel.
  * @see AbstractTaskMonitorPanel
*/
public class TaskCompletedEvent extends ChangeEvent {
    boolean completionStatus;
    String  taskName;

    public TaskCompletedEvent(Object source, boolean completionStatus) {
        this(source, source.getClass().getName(), completionStatus);
    }
        
    public TaskCompletedEvent(Object source, String taskName, boolean completionStatus) {
        super(source);
        this.taskName = taskName;
        this.completionStatus = completionStatus;
    }
    public String getTaskName() {
        return taskName;
    }
    public boolean getCompletionStatus() {
        return completionStatus;
    }
} 

