package org.trinet.util.graphics;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import org.trinet.util.*;

/**
 * Collection of JComboBoxes for specifying a DateTime; YR MO DY HR MN SEC
 */

public class DateTimeChooser extends JPanel
{
    DateTime defaultTime = new DateTime();
    DateTime now	     = new DateTime();	// set time to now

    NumberChooser yrChooser;
    MonthChooser moChooser;
//    JComboBox moChooser;
    NumberChooser dyChooser;
    NumberChooser hrChooser;
    NumberChooser mnChooser;
    NumberChooser secChooser;

    String title;

/**
 * constructor: sets default time to current time
 */ 
public DateTimeChooser()
{
//    buildPanel();
          try  {
               jbInit();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }
}
/**
 * constructor: sets default time to current time. String = border title.
 */ 
public DateTimeChooser(String ttl)
{
//    setTitle(ttl);
//    buildPanel();
    this (null, ttl);
}
/**
 * Constructor that sets initial values to those in DateTime object
 */
public DateTimeChooser(DateTime dt)
{
//    defaultTime = dt;
//    buildPanel();
      this (dt, null);
}

/**
 * Constructor that sets initial values to those in DateTime object. String = border title.
 */
public DateTimeChooser(DateTime dt, String ttl)
{
    if (dt != null)  defaultTime = dt;
    if (ttl != null) setTitle(ttl);
          try  {
               jbInit();
          }
          catch(Exception ex) {
               ex.printStackTrace();
          }

//    buildPanel();
}

public void setTitle (String ttl)
{
    title = ttl;
}

public void setTime (DateTime dt) {
       defaultTime = dt;

       yrChooser.setSelectedItem(""+defaultTime.getYear());
       moChooser.setSelectedIndex(defaultTime.getMonth());
       dyChooser.setSelectedItem(""+defaultTime.getDay());
       hrChooser.setSelectedItem(""+defaultTime.getHour());
       mnChooser.setSelectedItem(""+defaultTime.getMinute());
       secChooser.setSelectedItem(""+defaultTime.getSecond());

}

public void setTime (double epochSec) {

       setTime(new DateTime(epochSec));
}

public void jbInit()
{
    int yr   = defaultTime.getYear();
    int mo   = defaultTime.getMonth();
    int dy   = defaultTime.getDay();
    int hr   = defaultTime.getHour();
    int mn   = defaultTime.getMinute();
    int sec  = defaultTime.getSecond();


    int yrStart = yr-10, yrEnd = yr;
    int dyStart = 1, dyEnd = 31;
    int hrStart = 0, hrEnd = 23;
    int mnStart = 0, mnEnd = 59;
    int secStart = 0, secEnd = 59;
    int increment = 1;

// choosers
    yrChooser = new IntegerChooser(yrStart, yrEnd, increment, yr);

    moChooser = new MonthChooser();
    moChooser.setSelectedIndex(mo);

    dyChooser = new IntegerChooser(dyStart, dyEnd, increment, dy);
    hrChooser = new IntegerChooser(hrStart, hrEnd, increment, hr);
    mnChooser = new IntegerChooser(mnStart, mnEnd, increment, mn);
    secChooser = new NumberChooser(mnStart, secEnd, increment, sec);

// build the panel
    if (title != null) {
	TitledBorder border = new TitledBorder(title);
	border.setTitleColor(Color.black);
	setBorder( border );
    }

    setLayout( new GridLayout(2, 0) );

// labels
    Box vbox = new Box(BoxLayout.Y_AXIS);
    add(new JLabel("Year"));
    add(new JLabel("Month"));
    add(new JLabel("Day"));
    add(new JLabel("Hour"));
    add(new JLabel("Minute"));
    add(new JLabel("Second"));
  
    add(yrChooser);
    add(moChooser);
    add(dyChooser);
    add(hrChooser);
    add(mnChooser);
    add(secChooser);

// set sizes
       Dimension defSize = new Dimension(60, 26);
       yrChooser.setMaximumSize(defSize);
       moChooser.setMaximumSize(defSize);
       dyChooser.setMaximumSize(defSize);
       hrChooser.setMaximumSize(defSize);
       mnChooser.setMaximumSize(defSize);
       secChooser.setMaximumSize(defSize);

       yrChooser.setPreferredSize(defSize);
       moChooser.setPreferredSize(defSize);
       dyChooser.setPreferredSize(defSize);
       hrChooser.setPreferredSize(defSize);
       mnChooser.setPreferredSize(defSize);
       secChooser.setPreferredSize(defSize);

       defSize = new Dimension(55, 20);
       yrChooser.setMinimumSize(defSize);
       moChooser.setMinimumSize(defSize);
       dyChooser.setMinimumSize(defSize);
       hrChooser.setMinimumSize(defSize);
       mnChooser.setMinimumSize(defSize);
       secChooser.setMinimumSize(defSize);
}

/**
 * Return a DateTime object that is set by the dialog
 */
    public DateTime getDateTime()
    {
	return new DateTime(
		(int) yrChooser.getSelectedValue(),
		(int) moChooser.getSelectedIndex(),   // Jan.= 0
		(int) dyChooser.getSelectedValue(),
		(int) hrChooser.getSelectedValue(),
		(int) mnChooser.getSelectedValue(),
		secChooser.getSelectedValue());
    }
/** 
 * Return a double containing epoch seconds of data that is set by the dialog
 *
 * @see: EpochTime()
 */
    public double getEpochSeconds()
    {
     return getDateTime().getEpochSeconds();
     }

     /** Enable/disable all the active components that make up this component.*/
     public void setEnabled (boolean tf) {
        yrChooser.setEnabled(tf);
        moChooser.setEnabled(tf);
        dyChooser.setEnabled(tf);
        hrChooser.setEnabled(tf);
        mnChooser.setEnabled(tf);
        secChooser.setEnabled(tf);
     }
/** 
 * For debugging
 */
    public void dump ()
    {
      System.out.println (
		" yr= " + yrChooser.getSelectedValue()+
		" mo= " + moChooser.getSelectedIndex()+   // Jan.= 0
		" dy= " + dyChooser.getSelectedValue()+
		" hr= " + hrChooser.getSelectedValue()+
		" mn= " + mnChooser.getSelectedValue()+
		" sc= " + (double) secChooser.getSelectedValue());

      System.out.println (" New selection = " + getDateTime().toString());
    }
/**
 * Main for testing class
 * Note, needs:  import java.awt.event.*;
 */


    public static void main(String s[]) 
    {
	final DateTimeChooser tc1 = new DateTimeChooser("Start Time");
	final DateTimeChooser tc2 = new DateTimeChooser("End Time");

        JFrame frame = new JFrame("Main");
        frame.addWindowListener(new WindowAdapter()
	{
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });

// Get all sorts of scope errors with this...
/*	JButton button = new JButton("Show Result");
	button.addActionListener(new ActionListener()
	{
	  public void actionPerformed(ActionEvent e)
	     {
	//	DateTimeChooser.this.dump();
		dump();
	     }
         });

        frame.getContentPane().add("South", button);
*/
        JPanel rangePanel = new JPanel();
        rangePanel.setLayout(new BoxLayout(rangePanel, BoxLayout.Y_AXIS));
        rangePanel.add(tc1);
        rangePanel.add(tc2);

        JPanel panel = new JPanel(new BorderLayout());
        panel.add (rangePanel, BorderLayout.CENTER);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener() {

           public void actionPerformed(ActionEvent e) {
               System.out.println ("-- Times AFTER --");

               System.out.println ("start "+tc1.getDateTime().toString());
               System.out.println ("end   "+tc2.getDateTime().toString());
               System.out.println (" size = "+ tc1.yrChooser.getSize());
               System.out.println ("msize = "+ tc1.yrChooser.getMaximumSize());
               System.out.println ("psize = "+ tc1.yrChooser.getPreferredSize());
               System.out.println ("-----------");

           }
        });

        panel.add(okButton, BorderLayout.SOUTH);
        frame.getContentPane().add(panel);

          frame.getContentPane().add(panel);

	frame.setSize(200,30);	// this has no effect!
        frame.pack();
        frame.setVisible(true);

    }

} // end of class

