package org.trinet.util.gazetteer.TN;
import org.trinet.util.gazetteer.*;
import java.sql.*;
import java.io.*;
import org.trinet.jdbc.JDBCConnect;
import java.util.Vector;
import java.util.Collection;

// DDG
import org.trinet.jasi.DataSource;

public class WheresFrom extends WhereIsEngine{
    static Connection CONNECTION;
    static {
	try {
		//CONNECTION = JDBCConnect.createDefaultConnection();
                if (CONNECTION == null) CONNECTION = DataSource.getConnection();   //DDG 11/12/02
                if (CONNECTION == null) throw new NullPointerException("Warning Default connection is null.");
//                if (CONNECTION == null) System.err.println("Warning Default connection is null.");
	}
	catch (Exception ex) {
		System.err.println(ex.getMessage());
                ex.printStackTrace();
	}
    }

    private static final WhereBasicTown wTown = new WhereBasicTown(CONNECTION);
    private static final WhereBasicBigTown wBigTown = new WhereBasicBigTown(CONNECTION);
    private static final WhereBasicQuarry wQuarry = new WhereBasicQuarry(CONNECTION);
    private static final WhereBasicQuake wQuake = new WhereBasicQuake(CONNECTION);
    private static final WhereStation wStn = new WhereStation(CONNECTION);
    private static final WhereFault wFault = new WhereFault(CONNECTION);

/** Database table gazetteer location type */
    public static final String TOWN = GazetteerType.TOWN.getName();
/** Database table gazetteer location type */
    public static final String BIG_TOWN = GazetteerType.BIG_TOWN.getName();
/** Database table gazetteer location type */
    public static final String QUARRY = GazetteerType.QUARRY.getName();
/** Database table gazetteer location type */
    public static final String QUAKE = GazetteerType.QUAKE.getName();
/** Database table gazetteer location type */
    public static final String STATION = GazetteerType.STATION.getName();
/** Database table gazetteer location type */
    public static final String FAULT = GazetteerType.FAULT.getName();

    private static GeoidalUnits distanceUnits = GeoidalUnits.KILOMETERS;

/** Reference location */
    Geoidal reference;


    protected void finalize() {
	if (CONNECTION != null) {
	    try {
		CONNECTION.close();
	    }
	    catch (Exception ex) {}
	}
    }

/** Returns the current WhereAmI object for the specified polymorphic type.
* Returns null if type is unknown.<BR>
* Example usage for a WhereAmI object, to recover a formatted String representation or the raw number data:
* <blockquote>
  <PRE>
*	wai = WheresFrom.getWhereType(WheresFrom.TOWN); <BR>
*	wai.setReference(lat, lon, z); // specify target (event location) <BR>
*	WhereSummary [] wi = wai.getClosestByCount(1); <BR>
*	String results = wi[0].toString(GeoidalUnits.MILES); // need to parse String for data items <BR>
*	DistanceAzimuthElevation dae = wi[0].getDistanceAzimuthElevation(); <BR>
*	double distance = dae.getDistanceMiles();	 // getDistance() default is km <BR>
*       GazetteerData gd = wi.getGazetteerData();
*       String name = gd.getName();
  </PRE>
* </blockquote>
*/
    public static WhereAmI getWhereType(String type) {
	if (type.equalsIgnoreCase(TOWN)) {
	    return wTown;
	}
	else if (type.equalsIgnoreCase(BIG_TOWN)) {
	    return wBigTown;
	}
	else if (type.equalsIgnoreCase(QUARRY)) {
	    return wQuarry;
	}
	else if (type.equalsIgnoreCase(QUAKE)) {
	    return wQuake;
	}
	else if (type.equalsIgnoreCase(STATION)) {
	    return wStn;
	}
	else if (type.equalsIgnoreCase(FAULT)) {
	    return wFault;
	}
	return null;
    }


    /* added by DK 11/04/2002 to provide functionality spec'd in
     *  WhereIsEngine
     ************************************************************/
    public void setReference(double lat, double lon, double z)
    {
	this.reference = (Geoidal) new LatLonZ(lat, lon, z);
	wTown.setReference(lat, lon, z);
	wBigTown.setReference(lat, lon, z);
	wQuarry.setReference(lat, lon, z);
	wQuake.setReference(lat, lon, z);
	wStn.setReference(lat, lon, z);
	wFault.setReference(lat, lon, z);
    }


    public WhereSummary WhereSummaryType(String type)
    {
      WhereAmI wai = WheresFrom.getWhereType(type);
      WhereSummary [] wi = wai.getClosestItemsByCount(1);
      if(wi == null || wi.length == 0)
        return(null);
      else
        return(wi[0]);
    }

    public Collection WhereSummary()
    {
      Vector WhereSummaryList = new Vector();

	WhereSummaryList.add(WhereSummaryType(TOWN));
	WhereSummaryList.add(WhereSummaryType(BIG_TOWN));
	WhereSummaryList.add(WhereSummaryType(QUARRY));
	WhereSummaryList.add(WhereSummaryType(QUAKE));
	WhereSummaryList.add(WhereSummaryType(STATION));
	WhereSummaryList.add(WhereSummaryType(FAULT));
        return(WhereSummaryList);
    }

/* True == database REMARK columns is included in output strings. */
    public static void setIncludeRemark(boolean includeRemark) {
	wTown.setIncludeRemark(includeRemark);
	wBigTown.setIncludeRemark(includeRemark);
	wQuarry.setIncludeRemark(includeRemark);
	wQuake.setIncludeRemark(includeRemark);
	wStn.setIncludeRemark(includeRemark);
	wFault.setIncludeRemark(includeRemark);
    }

/** GeoidalUnits.MILES == distances are reported in miles in the output text strings.
* GeoidalUnits.KILOMETERS (default) == distances reported in kilometers in the output text strings. */
    public void setDistanceUnits(GeoidalUnits units) {
	wTown.setDistanceUnits(units);
	wBigTown.setDistanceUnits(units);
	wQuarry.setDistanceUnits(units);
	wQuake.setDistanceUnits(units);
	wStn.setDistanceUnits(units);
	wFault.setDistanceUnits(units);
	distanceUnits = units;
    }
    public void setDistanceUnitsKm() {
	setDistanceUnits(GeoidalUnits.KILOMETERS);
    }
    public void setDistanceUnitsMiles() {
	setDistanceUnits(GeoidalUnits.MILES);
    }

/** Returns String describing where the specified location is relative to closest database entry for all known database types. */
    public String where() {
      return(where(reference.getLat(), reference.getLon(), reference.getZ()));
    }

/** Returns String describing where the specified location is relative to closest database entry for all known database types. */
    public String where(double lat, double lon) {
	return where(lat, lon, 0., 1);
    }
/** Returns String describing where the specified location is relative to the specified number of database entries
* for all known database types.
*/
    public String where(double lat, double lon, int number) {
	return where(lat, lon, 0., number);
    }
/** Returns String describing where the specified location is relative to closest database entry for all known database types.
* Uses z to determine elevation.
*/
    public String where(double lat, double lon, double z) {
	return where(lat, lon, z, 1);
    }
/** Returns String describing where the specified location (int degrees and decimal minutes) is relative to the input number
* of database entries for all known types.  Uses z to determine elevation.
*/
    public String where(int lat, double latmin, int lon, double lonmin, double  z, int number) {
	return where(GeoidalConvert.toDecimalDegrees(lat, latmin), GeoidalConvert.toDecimalDegrees(lon, lonmin),
		z, number);
    }
/** Returns String describing where the specified location is relative to input number of database entries for
*all known database types. Uses z to determine elevation.
*/
    public String where(double lat, double lon, double z, int number) {
	StringBuffer sb = new StringBuffer(2048);
	sb.append(wTown.from(lat, lon, z, number));
	sb.append(wBigTown.from(lat, lon, z, number));
	sb.append(wQuarry.from(lat, lon, z, number));
	sb.append(wQuake.from(lat, lon, z, number));
	sb.append(wStn.from(lat, lon, z, number));
	sb.append(wFault.from(lat, lon, z, number));
	return sb.toString();
    }

/** Returns String describing where the specified location is relative to the input number of database entries
* for the input database type. Uses z to determine elevation.
*/
    public String whereType(double lat, double lon, double z, String type) {
      return(whereType(lat,lon,z,1,type));
    }

/** Returns String describing where the specified location is relative to the input number of database entries
* for the input database type. Uses z to determine elevation.
*/
    public String whereType(double lat, double lon, double z, int number, String type) {
	if (type.equalsIgnoreCase(TOWN)) {
	    return wTown.from(lat, lon, z, number);
	}
	else if (type.equalsIgnoreCase(BIG_TOWN)) {
	    return wBigTown.from(lat, lon, z, number);
	}
	else if (type.equalsIgnoreCase(QUARRY)) {
	    return wQuarry.from(lat, lon, z, number);
	}
	else if (type.equalsIgnoreCase(QUAKE)) {
	    return wQuake.from(lat, lon, z, number);
	}
	else if (type.equalsIgnoreCase(STATION)) {
	    return wStn.from(lat, lon, z, number);
	}
	else if (type.equalsIgnoreCase(FAULT)) {
	    return wFault.from(lat, lon, z, number);
	}
	else {
	    return null;
	}
    }

    public String whereType(String type) {
	if (type.equalsIgnoreCase(TOWN)) {
	    return wTown.reportClosestByCount(1);
	}
	else if (type.equalsIgnoreCase(BIG_TOWN)) {
	    return wBigTown.reportClosestByCount(1);
	}
	else if (type.equalsIgnoreCase(QUARRY)) {
	    return wQuarry.reportClosestByCount(1);
	}
	else if (type.equalsIgnoreCase(QUAKE)) {
	    return wQuake.reportClosestByCount(1);
	}
	else if (type.equalsIgnoreCase(STATION)) {
	    return wStn.reportClosestByCount(1);
	}
	else if (type.equalsIgnoreCase(FAULT)) {
	    return wFault.reportClosestByCount(1);
	}
	else {
	    return null;
	}
    }

    public static final void getClosestTown(double lat, double lon, double z,
		 double [] dist, double [] az, double [] elev, String [] place) {
	wTown.setReference(lat, lon, z);
	WhereSummary []  whereItem = wTown.getClosestItemsByCount(1);
	if (whereItem == null) return;
	setOutputParameters(whereItem[0], dist, az, elev, place);
    }

    public static final void getClosestBigTown(double lat, double lon, double z,
		 double [] dist, double [] az, double [] elev, String [] place) {
	wBigTown.setReference(lat, lon, z);
	WhereSummary []  whereItem = wBigTown.getClosestItemsByCount(1);
	if (whereItem == null) return;
	setOutputParameters(whereItem[0], dist, az, elev, place);
    }

    public static final void getClosestQuarry(double lat, double lon, double z,
		 double [] dist, double [] az, double [] elev, String [] place) {
	wQuarry.setReference(lat, lon, z);
	WhereSummary []  whereItem = wQuarry.getClosestItemsByCount(1);
	if (whereItem == null) return;
	place[0] = whereItem[0].fromPlaceString(true);
	setOutputParameters(whereItem[0], dist, az, elev, place);
    }

    public static final void getClosestQuake(double lat, double lon, double z,
		 double [] dist, double [] az, double [] elev, String [] place) {
	wQuake.setReference(lat, lon, z);
	WhereSummary []  whereItem = wQuake.getClosestItemsByCount(1);
	if (whereItem == null) return;
	setOutputParameters(whereItem[0], dist, az, elev, place);
    }

    public static final void getClosestStation(double lat, double lon, double z,
		 double [] dist, double [] az, double [] elev, String [] place) {
	wStn.setReference(lat, lon, z);
	WhereSummary []  whereItem = wStn.getClosestItemsByCount(1);
	if (whereItem == null) return;
	setOutputParameters(whereItem[0], dist, az, elev, place);
    }

    public static final void getClosestFault(double lat, double lon, double z,
		 double [] dist, double [] az, double [] elev, String [] place) {
	wFault.setReference(lat, lon, z);
	WhereSummary []  whereItem = wFault.getClosestItemsByCount(1);
	if (whereItem == null) return;
	setOutputParameters(whereItem[0], dist, az, elev, place);
    }

    private static void setOutputParameters(WhereSummary whereItem, double [] dist, double [] az, double [] elev, String [] place) {
	DistanceAzimuthElevation distanceAzimuthElevation = whereItem.getDistanceAzimuthElevation();
	dist[0] = distanceAzimuthElevation.getDistance(distanceUnits);
	az[0] = distanceAzimuthElevation.getAzimuth();
	elev[0] = distanceAzimuthElevation.getElevation();
	place[0] = whereItem.fromPlaceString(true);
    }

/*
    public static String whereTown(double lat, double lon) {
	return whereTown(lat, lon, 0., 1);
    }
    public static String whereTown(double lat, double lon, double z) {
	return whereTown(lat, lon, z, 1);
    }
    public static String whereTown(double lat, double lon, int number) {
	return whereTown(lat, lon, 0., number);
    }
    public static String whereTown(int lat, double latmin, int lon, double lonmin, double  z, int number) {
	return whereTown(GeoidalConvert.toDecimalDegrees(lat, latmin), GeoidalConvert.toDecimalDegrees(lon, lonmin), z, number);
    }
    public static String whereTown(double lat, double lon, double z, int number) {
	return whereType(lat, lon, z, number, TOWN);
    }

    public static String whereQuarry(double lat, double lon) {
	return whereQuarry(lat, lon, 0., 1);
    }
    public static String whereQuarry(double lat, double lon, double z) {
	return whereQuarry(lat, lon, z, 1);
    }
    public static String whereQuarry(double lat, double lon, int number) {
	return whereQuarry(lat, lon, 0., number);
    }
    public static String whereQuarry(int lat, double latmin, int lon, double lonmin, double  z, int number) {
	return whereQuarry(GeoidalConvert.toDecimalDegrees(lat, latmin), GeoidalConvert.toDecimalDegrees(lon, lonmin), z, number);
    }
    public static String whereQuarry(double lat, double lon, double z, int number) {
	return whereType(lat, lon, z, number, QUARRY);
    }

    public static String whereQuake(double lat, double lon) {
	return whereQuake(lat, lon, 0., 1);
    }
    public static String whereQuake(double lat, double lon, double z) {
	return whereQuake(lat, lon, z, 1);
    }
    public static String whereQuake(double lat, double lon, int number) {
	return whereQuake(lat, lon, 0., number);
    }
    public static String whereQuake(int lat, double latmin, int lon, double lonmin, double  z, int number) {
	return whereQuake(GeoidalConvert.toDecimalDegrees(lat, latmin), GeoidalConvert.toDecimalDegrees(lon, lonmin), z, number);
    }
    public static String whereQuake(double lat, double lon, double z, int number) {
	return whereType(lat, lon, z, number, QUAKE);
    }
*/
}
