package org.trinet.util;
import java.util.*;

/**
 * List of string elements such as those parsed from a String property value.
*/
public class StringList {
    List stringList;

    public StringList(String [] strings) {
        if (strings == null) stringList = new ArrayList(0);
        else stringList = Arrays.asList(strings);
    }

/** Returns number of elements in the list. */
    public int size() {
        return stringList.size();
    }


/**
 * Returns the list.
*/
    public List getList() {
	return stringList;
    }

/**
 * Adds a String element to end of list.
*/
    public void add(String value) {
	stringList.add(value);
    }

/**
* Removes the input String if it is in the list.
*/
    public boolean remove(String value) {
        return stringList.remove(value);
    }

/**
* Returns the String array comprising the list.
*/
    public String [] toArray() {
        return (String []) stringList.toArray(new String[stringList.size()]);
    }

/**
* Return true if input String is within specified bounds inclusive.
*/
    public boolean contains(String value) {
        return stringList.contains(value);
    }

/**
* Returns concatenation of String elements of list where each element is separated by ", "
*/
    public String toString() {

        StringBuffer sb = new StringBuffer(256);
        Iterator iter = stringList.iterator();

        while (iter.hasNext()) {
            sb.append((String) iter.next());
            sb.append(", ");
        }
        int len = sb.length();
        if (len > 0) return sb.substring(0, len - 2);
        else return "";
    }

/**
* Returns true if a String list can be parsed from input StringTokenizer.
* Does not create list and returns false if tokenizer.hasMoreTokens() == false.
*/
    public boolean parseValue(StringTokenizer tokenizer) {
        int count = tokenizer.countTokens();
        if (count <= 0) return false;
        stringList = new ArrayList(count);
        for (int index = 0; index < count; index++) { 
            add(tokenizer.nextToken());
        }
        return true;
    }

}
